# Claude Code Production Engineering ⚡

Ship production code at 10X speed with Claude Code. Not installation scripts — actual patterns, workflows, and techniques.

## Install

```bash
clawhub install afrexai-claude-code-production
```

## What's Inside

- **CLAUDE.md architecture** — template + rules for maximum context efficiency
- **5 prompting patterns** that actually work (task brief, show don't tell, incremental, evidence-based, architecture discussion)
- **Context management system** — when to compact, when to start fresh, habits that save tokens
- **Sub-agent orchestration** — parallel productivity with Task tool and handoff documents
- **DEBUG protocol** — systematic debugging, not random guessing
- **Safe refactoring** — multi-file changes without breaking anything
- **TDD loop with Claude** — tests as acceptance criteria, minimum code to pass
- **Git workflow** — commit strategy, PR creation, branch management
- **Code review mode** — use Claude as reviewer before PRs
- **Production checklist** — P0/P1/P2 checks before deploying AI-generated code
- **Speed multipliers** — model selection, slash commands, session stacking
- **4 workflow templates** — new feature, bug fix, refactoring, research spike
- **Productivity metrics** — track and improve your output weekly

## Quick Start

1. Install the skill
2. Run: "Set up my project for Claude Code"
3. Start coding with Task Brief prompts (see §2)

## vs. Other Claude Code Skills

Other skills install Claude Code and create subagent configs. This skill teaches you the **methodology** — how to prompt, manage context, debug, refactor, test, and ship. Zero scripts, pure knowledge.

## ⚡ Level Up

Want production-grade AI context for your specific industry?

**[AfrexAI Context Packs — $47](https://afrexai-cto.github.io/context-packs/)** — Complete agent configurations for SaaS, Fintech, Healthcare, Legal, Ecommerce, and 5 more verticals.

## 🔗 More Free Skills by AfrexAI

- [afrexai-prompt-engineering](https://clawhub.com/skills/afrexai-prompt-engineering) — CRAFT framework for writing better prompts
- [afrexai-code-reviewer](https://clawhub.com/skills/afrexai-code-reviewer) — SPEAR code review framework
- [afrexai-technical-docs](https://clawhub.com/skills/afrexai-technical-docs) — Documentation engineering system
- [afrexai-devops-engine](https://clawhub.com/skills/afrexai-devops-engine) — Complete CI/CD + platform engineering
- [afrexai-system-architect](https://clawhub.com/skills/afrexai-system-architect) — System design methodology

**[Browse all AfrexAI skills →](https://afrexai-cto.github.io/context-packs/)**
