# Childcare & Daycare Compliance Agent

Licensing, safety, staffing, and operational compliance for childcare centers, family daycare homes, and early learning programs in the US.

## What This Covers

- State licensing requirements and renewal timelines
- Staff-to-child ratios by age group (infant through school-age)
- Background check requirements (FBI, state, sex offender registry, child abuse clearance)
- Health and safety standards (CPSC, fire marshal, sanitation, immunization tracking)
- QRIS (Quality Rating and Improvement System) participation
- CCDF/CCDBG subsidy compliance and audit preparation
- ADA accessibility and inclusion requirements
- Incident reporting, medication administration, and emergency preparedness
- NAEYC / NECPA accreditation standards
- Parent communication and documentation requirements

## Licensing Categories

| Type | Capacity | Typical Requirements |
|------|----------|---------------------|
| Family Child Care Home | 1-6 children | Home inspection, provider CPR/First Aid, basic background check |
| Large Family Child Care | 7-12 children | Assistant required, enhanced inspection, zoning approval |
| Child Care Center | 13+ children | Director qualifications (CDA/degree), multiple staff, annual inspections |
| School-Age Program | Varies | Before/after school, summer camps, separate licensing in most states |
| Drop-In Care | Varies | Limited hours per child, modified ratios in some states |

## Staff-to-Child Ratios (Common State Requirements)

| Age Group | Typical Ratio | Max Group Size |
|-----------|--------------|----------------|
| Infants (0-12 mo) | 1:3 to 1:4 | 6-8 |
| Young Toddlers (12-18 mo) | 1:3 to 1:4 | 6-8 |
| Toddlers (18-36 mo) | 1:4 to 1:6 | 8-12 |
| Preschool (3-4 yr) | 1:8 to 1:10 | 16-20 |
| Pre-K (4-5 yr) | 1:10 to 1:12 | 20-24 |
| School-Age (5-12 yr) | 1:12 to 1:15 | 24-30 |

**Note:** Ratios vary significantly by state. Always verify with your state licensing agency. NAEYC accreditation requires stricter ratios.

## Background Check Requirements (CCDBG Act 2014, Updated)

Every childcare employee, volunteer with unsupervised access, and household member (family homes) must complete:

| Check | Source | Frequency |
|-------|--------|-----------|
| FBI fingerprint | FBI via state agency | Every 5 years |
| State criminal history | State police/bureau | Every 5 years |
| Sex offender registry | National (NSOPW) + state | Every 5 years |
| Child abuse/neglect registry | State child welfare | Every 5 years |
| In-state check for each state lived in past 5 years | Individual state agencies | Initial hire |

**Disqualifying offenses (federal mandate):** Murder, child abuse/neglect, spousal abuse, crimes against children, rape/sexual assault, arson, kidnapping, felony physical assault (within 5 years), felony drug offense (within 5 years).

## Health & Safety Training (Minimum Pre-Service)

All caregivers must complete training in these areas within 90 days of hire (some states require pre-service):

1. Prevention and control of infectious diseases (including immunization)
2. SIDS and safe sleep practices
3. Medication administration
4. Prevention of shaken baby syndrome / abusive head trauma
5. Emergency preparedness and response
6. Handling and storage of hazardous materials
7. Appropriate precautions for transporting children
8. Pediatric first aid and CPR
9. Child development (age-appropriate practices)
10. Recognizing and reporting child abuse and neglect

**Annual continuing education:** 15-24 hours/year (varies by state). Director typically needs 24-30 hours/year.

## Facility Safety Checklist

### Indoor Requirements
- [ ] Working smoke detectors in every room (test monthly, replace batteries annually)
- [ ] Fire extinguisher (ABC type) within 75 feet of every point, inspected annually
- [ ] Carbon monoxide detectors on every level
- [ ] Electrical outlets covered or tamper-resistant
- [ ] Cleaning supplies, medications, sharp objects locked and inaccessible
- [ ] Hot water temperature ≤120°F at all child-accessible fixtures
- [ ] Working phone with emergency numbers posted
- [ ] First aid kit stocked and accessible to staff (not children)
- [ ] Cribs meet current CPSC standards (no drop-sides, firm mattress, no bumpers)
- [ ] Furniture anchored to walls (bookcases, shelving)

### Outdoor Requirements
- [ ] Fenced play area (minimum 4 feet, self-closing gate)
- [ ] Playground equipment age-appropriate with proper fall zones
- [ ] 75 square feet per child outdoor space (minimum)
- [ ] No standing water, toxic plants, or accessible pools
- [ ] Shade available
- [ ] Surface under equipment: 12 inches of mulch/wood chips or rubber matting

### Kitchen/Food Service
- [ ] Food handler certification for staff preparing meals
- [ ] USDA CACFP participation (if accepting subsidies)
- [ ] Allergy documentation for every child, posted in prep area
- [ ] Menu posted 1 week in advance, copies available to parents

## Incident Reporting Requirements

| Incident Type | Report To | Timeframe |
|--------------|-----------|-----------|
| Serious injury requiring medical attention | Licensing agency + parent | Within 24 hours |
| Death of child in care | Licensing agency + law enforcement | Immediately |
| Suspected abuse/neglect | Child protective services hotline | Immediately (mandated reporter) |
| Communicable disease outbreak | Local health department | Within 24 hours |
| Fire, flood, or facility damage | Licensing agency | Within 24 hours |
| Missing child | Law enforcement + parent + licensing | Immediately |
| Medication error | Parent + licensing (if injury) | Same day |

## Financial Compliance

### CCDF Subsidy Programs
- Accept subsidy payments → must meet all CCDBG health/safety requirements
- Attendance records: daily sign-in/sign-out with full signature and time
- Cannot charge families more than published private-pay rate minus subsidy
- Retain records for 3-5 years (state-dependent)

### Tax Considerations
- Family home providers: Schedule C, may deduct time-space percentage of home expenses
- Centers: Standard business entity (LLC, S-Corp common)
- Staff: W-2 employees (not 1099) — DOL is aggressive on misclassification in childcare
- Tax credit: Employer-provided childcare (Section 45F) = 25% of qualified expenses, max $150K

## QRIS Participation

Quality Rating and Improvement Systems operate in 44+ states. Typical 3-5 star structure:

| Level | Typical Criteria |
|-------|-----------------|
| 1 Star | Meets basic licensing |
| 2 Stars | Director has CDA + annual training plan |
| 3 Stars | Curriculum aligned to state early learning standards, family engagement plan |
| 4 Stars | Environmental rating scale (ERS) score ≥5.0, professional development plan |
| 5 Stars | NAEYC/NECPA accredited, data-driven improvement, mentoring |

Higher ratings = higher subsidy reimbursement rates (tiered) and parent preference.

## Key Dates & Deadlines

| Task | Frequency |
|------|-----------|
| License renewal | Annual (most states) |
| Fire inspection | Annual |
| Health/sanitation inspection | Annual or biannual |
| Background check renewal | Every 5 years |
| CPR/First Aid certification | Every 2 years |
| Playground safety audit | Annual |
| Emergency drill (fire) | Monthly |
| Emergency drill (severe weather/lockdown) | Quarterly |
| Staff performance evaluations | Annual |
| Policy handbook update | Annual |

## How to Use This Skill

When asked about childcare compliance:
1. Identify the state — requirements vary significantly
2. Identify the program type (family home vs center vs school-age)
3. Check ratios, background checks, training requirements for that context
4. Reference specific federal mandates (CCDBG, CPSC, ADA) as baseline
5. Always recommend verifying with state licensing agency for current rules

For operational setup, staffing plans, or financial modeling for childcare businesses, see the [AfrexAI Context Packs](https://afrexai-cto.github.io/context-packs/) — industry-specific AI agent configurations starting at $47.
