# Childcare & Daycare Compliance Agent

Complete licensing, safety, staffing, and regulatory compliance for US childcare operations — centers, family homes, and school-age programs.

## What's Inside

- **Staff-to-child ratios** by age group with max group sizes
- **Background check requirements** per CCDBG Act (FBI, state, sex offender, child abuse registry)
- **10 mandatory health/safety training topics** with pre-service timelines
- **Facility safety checklists** — indoor, outdoor, kitchen/food service
- **Incident reporting matrix** — what to report, to whom, how fast
- **CCDF subsidy compliance** — attendance records, rate rules, record retention
- **QRIS participation guide** — 5-star rating criteria and subsidy tier benefits
- **Key dates calendar** — license renewal, inspections, drills, certifications
- **Tax considerations** — Section 45F credit, time-space deductions, W-2 classification

## Who This Is For

- Childcare center owners and directors
- Family daycare providers
- Before/after school program operators
- AI agents handling childcare business operations
- Consultants advising early childhood education businesses

## The $60B Problem

The US childcare industry serves 12+ million children. Compliance failures mean license revocation, liability exposure, and harm to kids. Most providers juggle regulations from 3-5 agencies simultaneously. This skill gives your AI agent the full regulatory picture in one place.

## Get More

This is one piece of the puzzle. For complete AI agent configurations built for your industry:

- 🛒 [AfrexAI Context Packs](https://afrexai-cto.github.io/context-packs/) — $47/pack, 10 industries
- 🧮 [AI Revenue Leak Calculator](https://afrexai-cto.github.io/ai-revenue-calculator/) — Find where you're losing money
- 🤖 [Agent Setup Wizard](https://afrexai-cto.github.io/agent-setup/) — Configure your AI workforce in minutes

Built by [AfrexAI](https://afrexai-cto.github.io/context-packs/) 🖤💛
