# Childcare Center Operations

Run a profitable daycare or childcare center. Covers licensing, staffing ratios, tuition pricing, facility requirements, parent retention, and growth — built from real operator data.

## Revenue & Tuition Pricing (2026)

| Age Group | Weekly Tuition (Metro) | Weekly Tuition (Suburban) | Teacher:Child Ratio |
|---|---|---|---|
| Infant (6wk-12mo) | $350-$500 | $225-$375 | 1:3 to 1:4 |
| Toddler (12-24mo) | $300-$425 | $200-$325 | 1:4 to 1:5 |
| Two-year-olds | $275-$375 | $175-$300 | 1:5 to 1:6 |
| Preschool (3-4yr) | $250-$350 | $150-$275 | 1:8 to 1:10 |
| Pre-K (4-5yr) | $225-$325 | $140-$250 | 1:10 to 1:12 |
| School-age (before/after) | $125-$200 | $100-$175 | 1:12 to 1:15 |

**Annual revenue per child (infant)**: $13,000-$26,000
**Annual revenue per child (preschool)**: $7,800-$18,200
**Average center revenue**: $500,000-$2,000,000 (60-150 enrolled children)

## Staffing & Labor

| Role | Salary Range | Notes |
|---|---|---|
| Center Director | $45,000-$75,000 | Required by most states |
| Lead Teacher | $30,000-$45,000 | CDA or degree required |
| Assistant Teacher | $25,000-$35,000 | High school diploma + training |
| Floater/Sub | $24,000-$32,000 | Covers breaks and absences |
| Cook | $28,000-$38,000 | If serving meals on-site |
| Admin/Front Desk | $30,000-$40,000 | Billing, enrollment, parent comms |

**Labor as % of revenue**: 55-65% (largest expense by far)
**Turnover rate**: 26-40% industry average — retention is survival
**Retention tactics**: Tuition discounts for staff children, PTO, health benefits, CDA sponsorship

## Licensing & Compliance

**State licensing (all states require):**
- Background checks (FBI fingerprint + state) for all staff
- Staff:child ratios (varies by state and age group)
- Square footage: 35-50 sq ft per child indoors, 75+ sq ft outdoors
- Health & safety inspections (annual or biannual)
- Fire marshal approval
- Zoning approval for childcare use

**Federal:**
- USDA Child and Adult Care Food Program (CACFP) — reimburses $3-$5/child/day for meals
- ADA compliance (facility accessibility)
- FLSA labor law compliance

**Accreditation (optional, premium positioning):**
- NAEYC — gold standard, 7% of centers accredited
- NECPA — alternative national accreditation
- State Quality Rating (QRS/QRIS) — star ratings affect subsidy rates

## Financial Benchmarks

| Metric | Target |
|---|---|
| Enrollment capacity utilization | 85-95% |
| Net profit margin | 10-18% |
| Labor cost | 55-65% of revenue |
| Occupancy/rent | 10-15% of revenue |
| Food cost | 5-8% of revenue |
| Supplies & curriculum | 3-5% of revenue |
| Insurance (liability + workers comp) | 2-4% of revenue |
| Marketing | 2-3% of revenue |
| Annual tuition increase | 3-5% |

## Startup Costs

| Item | Cost Range |
|---|---|
| Facility buildout/renovation | $150,000-$500,000 |
| Licensing & permits | $2,000-$10,000 |
| Furniture & equipment | $30,000-$75,000 |
| Playground equipment | $20,000-$60,000 |
| Curriculum materials | $5,000-$15,000 |
| Technology (cameras, software) | $5,000-$20,000 |
| Insurance deposits | $3,000-$8,000 |
| Working capital (3 months) | $50,000-$150,000 |
| **Total** | **$300,000-$850,000** |

## Parent Retention & Growth

- **Waitlist management**: If not maintaining a waitlist, you're underpriced or under-marketed
- **Tour conversion rate target**: 60-75%
- **Parent communication**: Daily reports (app-based — Brightwheel, HiMama), weekly curriculum updates
- **Re-enrollment rate target**: 85%+ year over year
- **Google reviews**: Target 4.7+ stars — #1 factor in parent selection
- **Referral program**: $200-$500 credit per enrolled referral
- **Community events**: open houses, holiday programs, summer camps (incremental revenue)
- **Subsidy acceptance**: CCDF/state subsidies fill seats but at lower rates — cap at 30-40% of enrollment

## Growth Playbook

**Stage 1: Single Center (60-80 kids, $500K-$1M)**
- Fill infant rooms first (highest revenue per square foot)
- Get NAEYC accredited within 2 years
- Build waitlist before expanding

**Stage 2: Optimized Single (100-150 kids, $1M-$2M)**
- Add pre-K and school-age programs
- Summer camp programs (fills summer dip)
- Maximize CACFP reimbursement

**Stage 3: Multi-Site ($2M-$5M)**
- Replicate model at second location
- Centralize admin, billing, HR
- Bulk purchasing for supplies and food

**Stage 4: Regional Brand ($5M+)**
- Franchise or corporate-owned expansion
- Employer-sponsored childcare contracts (major differentiator)
- Before/after school programs in elementary schools

## Industry Context (2026)
- $60B+ US childcare market, 500K+ providers
- Chronic shortage: only enough slots for 1 in 3 children who need care
- Political tailwind: bipartisan support for childcare funding
- Staffing crisis: wages lag other sectors, driving 30%+ turnover
- Technology: parent communication apps, automated billing, AI-assisted curriculum planning
- Employer-sponsored trend growing: companies subsidizing employee childcare

## Built by AfrexAI
More operations intelligence: https://afrexai-cto.github.io/context-packs/

- Full AI Context Packs — $47 each: https://afrexai-cto.github.io/context-packs/
- AI Revenue Leak Calculator (free): https://afrexai-cto.github.io/ai-revenue-calculator/
- Agent Setup Wizard (free): https://afrexai-cto.github.io/agent-setup/
