# Channel Partner Program Framework

Build, manage, and scale a channel partner program that generates indirect revenue without adding headcount.

## What This Does

Gives your AI agent everything it needs to design a partner program from scratch or audit an existing one. Covers partner tiers, deal registration, enablement, compensation, and performance management.

## When to Use

- Launching a channel/reseller/referral program
- Evaluating partner performance and ROI
- Designing partner compensation and tier structures
- Building partner enablement and co-marketing plans
- Auditing an existing program for leaks

## Partner Program Architecture

### Tier Structure

| Tier | Annual Revenue | Margin | MDF | Support | Certification |
|------|---------------|--------|-----|---------|---------------|
| Registered | $0-$50K | 15% | None | Portal only | None required |
| Silver | $50K-$200K | 20% | 2% of revenue | Dedicated CSM | 1 certified rep |
| Gold | $200K-$500K | 25% | 4% of revenue | Priority queue | 2 certified reps |
| Platinum | $500K+ | 30% | 6% of revenue | Named exec sponsor | 3+ certified reps |

### Partner Scoring Model (0-100)

Score each partner quarterly across 5 dimensions:

1. **Revenue Performance** (30 pts) — Quota attainment. 100% = 30 pts, pro-rated below
2. **Pipeline Generation** (20 pts) — New qualified opps created. 5+ = full marks
3. **Certification Compliance** (15 pts) — % of required certs current
4. **Customer Satisfaction** (20 pts) — CSAT/NPS from partner-sourced deals
5. **Engagement** (15 pts) — Portal logins, training completions, event attendance

**Thresholds:** <40 = probation, 40-59 = maintain, 60-79 = grow, 80+ = invest heavily

### Deal Registration Rules

- **Registration window:** 90 days from submission (extendable 30 days with justification)
- **Approval SLA:** 48 hours or auto-approved
- **Conflict resolution:** First to register wins. If direct rep has existing relationship, split 60/40 (direct/partner)
- **Protected margin:** Registered deals get full tier margin. Unregistered = 10% flat
- **No double-dipping:** Partner can't register deals from inbound leads already in your CRM

### Compensation Models

**Model 1: Reseller (Partner Owns the Customer)**
- Partner buys at discount, sets own price
- Margin: 20-35% depending on tier
- Partner handles billing, L1 support
- Best for: Geographic expansion, SMB segment

**Model 2: Referral (You Own the Customer)**
- Partner refers, you close and manage
- Commission: 10-20% of first-year revenue
- Optional: 5% recurring for renewal influence
- Best for: Strategic intros, advisory firms, tech partners

**Model 3: Co-Sell (Shared Ownership)**
- Joint selling motion, shared pipeline
- Split: Negotiate per deal (typically 70/30 or 60/40)
- Requires joint account planning
- Best for: Enterprise deals, complementary products

**Model 4: OEM/White-Label**
- Partner embeds your product in theirs
- Pricing: 40-60% discount off list
- Volume commitments required
- Best for: Platform plays, ISV partnerships

### Enablement Program

**Week 1-2: Foundation**
- Product deep dive (2 hours)
- ICP and positioning workshop (1 hour)
- Demo certification (pass/fail)
- Portal access and deal registration training

**Week 3-4: Sales Readiness**
- Objection handling playbook
- Competitive positioning
- Pricing and packaging walkthrough
- First joint call (shadow)

**Month 2-3: Independence**
- Solo demo certification
- First registered deal
- Co-marketing campaign launch
- QBR cadence established

### Co-Marketing Playbook

| Activity | Cost Share | Expected Leads | Partner Effort |
|----------|-----------|----------------|----------------|
| Joint webinar | 50/50 | 50-200 | Moderate |
| Co-branded content | You create, they distribute | 20-50/piece | Low |
| Event sponsorship | MDF-funded | 30-100 | High |
| Case study | You produce | Evergreen | Low |
| Partner directory listing | Free | 5-15/month | None |

### Partner QBR Template

Run quarterly with every Silver+ partner:

1. **Scorecard Review** — Current score vs. last quarter
2. **Pipeline Walk** — Every open opp, next steps, blockers
3. **Win/Loss Analysis** — What closed, what didn't, why
4. **Enablement Gaps** — Where reps are struggling
5. **Co-Marketing Plan** — Next quarter's joint activities
6. **Growth Plan** — Path to next tier, timeline, requirements
7. **Escalations** — Anything blocking progress

### Program Economics

**Unit Economics Per Partner:**
- Recruitment cost: $2,000-$5,000
- Enablement cost: $3,000-$8,000 (first year)
- Ongoing management: $500-$1,500/quarter
- Break-even: Typically 2-3 deals (6-9 months)

**Portfolio Targets:**
- 10 Registered partners per 1 Gold partner (natural pyramid)
- Top 20% of partners generate 80% of partner revenue
- Target: 30% of total revenue from channel by Year 3

**Red Flags:**
- Partner hasn't registered a deal in 90 days → outreach
- Certification lapsed → restrict deal registration
- CSAT below 3.5/5 on partner deals → enablement intervention
- Partner competing directly on >20% of deals → relationship review

### Channel Conflict Resolution

| Scenario | Resolution | Timeline |
|----------|-----------|----------|
| Partner vs. direct rep on same account | First touch + deal reg wins | 48 hrs |
| Two partners on same account | First to register, notify second | 24 hrs |
| Partner poaching another's customer | Warning → probation → termination | Immediate |
| Direct team targeting partner accounts | Block in CRM, escalate to channel chief | Same day |

### Program Launch Checklist

- [ ] Define ICP for ideal partner profile
- [ ] Build tier structure and margin table
- [ ] Create partner agreement (legal review)
- [ ] Set up partner portal (deal reg, content, training)
- [ ] Develop enablement curriculum (4-week ramp)
- [ ] Configure CRM for partner attribution
- [ ] Hire/assign channel manager (1 per 20-30 active partners)
- [ ] Create co-marketing budget and MDF policy
- [ ] Build partner scorecard and QBR template
- [ ] Set recruitment targets (10-20 partners in first 6 months)
- [ ] Announce program publicly

---

## Go Deeper

This framework gets you from zero to structured partner program. For industry-specific channel strategies:

- **SaaS partnerships**: Technology integrations, marketplace listings, API partnerships
- **Professional Services**: Referral networks, subcontracting, white-label delivery
- **Manufacturing**: Distributor networks, VAR programs, regional exclusivity

Get the full industry context at [AfrexAI Context Packs](https://afrexai-cto.github.io/context-packs/) ($47/pack) — 10 industries covered with ready-to-deploy agent configurations.

**Free tools:**
- [AI Revenue Leak Calculator](https://afrexai-cto.github.io/ai-revenue-calculator/) — Find where you're losing money
- [Agent Setup Wizard](https://afrexai-cto.github.io/agent-setup/) — Configure your AI agent in minutes

**Bundles:**
- Pick 3 Packs — $97
- All 10 Packs — $197
- Everything Bundle — $247
