# Change Management Planner

Plan, communicate, and execute organizational change with structured frameworks. Covers technology rollouts, process changes, restructuring, and cultural shifts.

## What It Does

When given a change initiative, generate:
1. **Stakeholder Impact Assessment** — who's affected, how, resistance likelihood (1-5)
2. **Communication Plan** — message timeline by audience (executives, managers, frontline)
3. **Training & Enablement Plan** — skills gaps, training format, timeline
4. **Resistance Mitigation** — anticipated objections + specific responses
5. **Rollout Phases** — pilot → controlled rollout → full deployment with go/no-go gates
6. **Success Metrics** — adoption rate, productivity impact, sentiment scores, timeline adherence

## Frameworks Supported
- **ADKAR** (Awareness, Desire, Knowledge, Ability, Reinforcement)
- **Kotter's 8-Step** (Urgency → Coalition → Vision → Communication → Empowerment → Quick Wins → Consolidation → Anchoring)
- **Lewin's** (Unfreeze → Change → Refreeze)

## Usage

Tell the agent about your change initiative:
- What's changing and why
- Timeline and budget constraints
- Organization size and culture
- Previous change attempts (successes/failures)

The agent will select the best framework and produce a complete change management plan.

## Output Format

Structured markdown with:
- Executive summary (1 paragraph)
- Stakeholder map (table: group | impact | resistance | strategy)
- Phase-by-phase timeline with owners and milestones
- Communication templates for each phase
- Risk register with mitigation actions
- 30/60/90 day success metrics

## When to Use

- Rolling out new software (ERP, CRM, AI tools)
- Restructuring teams or departments
- Changing business processes or workflows
- Mergers and acquisitions integration
- Cultural transformation initiatives

---

Built by [AfrexAI](https://afrexai-cto.github.io/context-packs/) — AI context packs for business automation.
