# Customer Acquisition Cost (CAC) Optimizer

Analyze, benchmark, and reduce your customer acquisition cost across every channel.

## What This Does
- Calculates true CAC (fully loaded — not just ad spend)
- Breaks down CAC by channel, segment, and cohort
- Benchmarks against industry standards
- Identifies the cheapest acquisition paths
- Models payback period and LTV:CAC ratio
- Generates a CAC reduction roadmap

## How to Use

Tell your agent:
- "Calculate our CAC for last quarter"
- "Break down acquisition cost by channel"
- "What's our LTV:CAC ratio?"
- "Build a plan to cut CAC by 30%"

## CAC Calculation Framework

### True CAC Formula (Fully Loaded)
```
CAC = (Sales Costs + Marketing Costs + Overhead Allocation) / New Customers Acquired

Include:
- Ad spend (paid search, social, display)
- Content production costs
- Sales team comp (base + commission + benefits)
- Marketing team comp
- Tools & software (CRM, analytics, ad platforms)
- Agency/contractor fees
- Event/sponsorship costs
- Allocated overhead (office, IT, management time)

Exclude:
- Customer success / retention costs (that's your retention CAC)
- Product development
- General admin not tied to acquisition
```

### CAC by Channel
| Channel | Typical B2B SaaS CAC | Typical B2C CAC | Payback Period |
|---------|---------------------|-----------------|----------------|
| Organic Search (SEO) | $200-$500 | $15-$50 | 6-12 months |
| Content Marketing | $300-$800 | $20-$80 | 8-14 months |
| Paid Search (Google) | $500-$2,000 | $30-$150 | 3-8 months |
| Paid Social (LinkedIn) | $800-$3,000 | $40-$200 | 4-10 months |
| Paid Social (Meta) | $300-$1,500 | $10-$80 | 2-6 months |
| Email / Nurture | $100-$400 | $5-$30 | 1-4 months |
| Referral Program | $150-$600 | $10-$50 | 1-3 months |
| Partner / Channel | $400-$1,200 | N/A | 3-6 months |
| Outbound Sales | $2,000-$8,000 | N/A | 6-18 months |
| Events / Conferences | $1,500-$5,000 | N/A | 6-12 months |

### Industry Benchmarks (2026)
| Industry | Median CAC | Good | Great | LTV:CAC Target |
|----------|-----------|------|-------|----------------|
| B2B SaaS (SMB) | $1,200 | <$800 | <$400 | 3:1+ |
| B2B SaaS (Mid-Market) | $5,500 | <$4,000 | <$2,500 | 3:1+ |
| B2B SaaS (Enterprise) | $15,000 | <$12,000 | <$8,000 | 5:1+ |
| Ecommerce (DTC) | $45 | <$30 | <$15 | 3:1+ |
| Fintech | $3,500 | <$2,500 | <$1,500 | 4:1+ |
| Healthcare SaaS | $6,000 | <$4,500 | <$3,000 | 4:1+ |
| Professional Services | $2,000 | <$1,500 | <$800 | 5:1+ |
| Construction Tech | $4,000 | <$3,000 | <$2,000 | 4:1+ |

### LTV:CAC Health Check
| Ratio | Status | Action |
|-------|--------|--------|
| <1:1 | 🔴 Burning cash | Stop spending. Fix product-market fit or pricing. |
| 1:1 - 2:1 | 🟡 Unsustainable | Optimize channels. Cut worst performers. |
| 3:1 | 🟢 Healthy | Standard target. Keep optimizing. |
| 4:1 - 5:1 | 🟢 Strong | Consider investing more in growth. |
| >5:1 | 🔵 Under-investing | You're leaving growth on the table. Spend more. |

### Payback Period
```
Payback Period (months) = CAC / (Monthly Revenue per Customer × Gross Margin %)

Target by stage:
- Seed/Series A: <18 months
- Series B+: <12 months  
- Profitable company: <6 months
```

## CAC Reduction Playbook

### Quick Wins (30 days)
1. **Kill underperforming channels** — Bottom 20% of channels by CAC efficiency → pause immediately
2. **Tighten ICP targeting** — Narrow ad audiences to best-fit segments (often cuts CAC 20-40%)
3. **Optimize landing pages** — A/B test headlines, CTAs, form length (10-30% conversion lift)
4. **Activate referral program** — Existing customers are your cheapest channel ($150-$600 vs $2K+ outbound)
5. **Fix lead scoring** — Sales time on bad leads = wasted CAC. Score ruthlessly.

### Medium-Term (90 days)
6. **Build content moat** — SEO compounds. Every ranking page reduces future CAC
7. **Automate nurture sequences** — Drip campaigns convert leads without sales time
8. **Partner channel deals** — Revenue share with complementary products
9. **Product-led growth hooks** — Free tier, trials, freemium → organic conversion
10. **Retargeting optimization** — 70% cheaper than cold acquisition

### Strategic (6+ months)
11. **Brand building** — Strong brand = lower CAC across every channel
12. **Community** — User communities generate organic referrals
13. **Product virality** — Built-in sharing, team invites, network effects

## Cohort Analysis Template
```
For each acquisition cohort (monthly):
- Cohort size (new customers)
- Total acquisition spend
- CAC per customer
- Month 1 revenue
- Month 3 cumulative revenue
- Month 6 cumulative revenue
- Month 12 cumulative revenue
- LTV at 12 months
- LTV:CAC at 12 months
- Payback month achieved (Y/N, which month)
- Retention rate at 12 months

Flag: Any cohort where LTV:CAC < 2:1 at 12 months
```

## Output Format
Present results as:
1. **CAC Summary** — Overall CAC, trend (up/down), LTV:CAC ratio
2. **Channel Breakdown** — Table ranked by efficiency (best CAC first)
3. **Benchmark Comparison** — How you stack up vs industry
4. **Top 3 Reduction Opportunities** — Specific, actionable, with estimated impact
5. **90-Day Roadmap** — Prioritized actions with expected CAC reduction %

---

*Built by [AfrexAI](https://afrexai-cto.github.io/context-packs/) — AI context packs for business operations ($47/pack)*

**More tools:**
- [AI Revenue Calculator](https://afrexai-cto.github.io/ai-revenue-calculator/) — Find where you're losing money
- [Agent Setup Wizard](https://afrexai-cto.github.io/agent-setup/) — Deploy AI agents in minutes
- [Context Pack Store](https://afrexai-cto.github.io/context-packs/) — Industry-specific AI agent configs
