# CAC Optimizer — Customer Acquisition Cost Framework

Calculate, benchmark, and reduce your customer acquisition cost across every channel.

## What's Inside
- **True CAC formula** — fully loaded, not just ad spend
- **Channel benchmarks** — 10 channels with typical CAC ranges
- **Industry benchmarks** — 8 industries with median/good/great thresholds
- **LTV:CAC health check** — instant diagnostic with action steps
- **Payback period calculator** — by company stage
- **CAC reduction playbook** — 13 tactics across 30/90/180-day horizons
- **Cohort analysis template** — track acquisition efficiency over time

## Install
```bash
clawhub install afrexai-cac-optimizer
```

## Why This Matters
Most companies only count ad spend as CAC. Real CAC includes sales comp, tools, content production, agency fees, and overhead. The difference is usually 2-4x what you think.

A $1,200 CAC looks fine until you realize your LTV is $1,500. That's a 1.25:1 ratio — you're barely breaking even.

## More from AfrexAI
- [Context Pack Store](https://afrexai-cto.github.io/context-packs/) — Industry-specific AI agent configs ($47/pack)
- [AI Revenue Calculator](https://afrexai-cto.github.io/ai-revenue-calculator/) — Find where you're losing money
- [Agent Setup Wizard](https://afrexai-cto.github.io/agent-setup/) — Deploy AI agents in minutes

**Bundles:** Pick 3 for $97 | All 10 for $197 | Everything for $247
