# Business Continuity Planner

Build a complete Business Continuity Plan (BCP) for any organization — in minutes instead of weeks.

Your AI agent walks you through Business Impact Analysis, risk scoring, recovery strategies, and communication chains, then outputs a ready-to-sign BCP document.

## Why This Exists

Most companies don't have a business continuity plan until something breaks. The ones that do often have a 50-page document nobody's read since 2019.

This skill generates a practical, testable BCP tailored to your actual operations. Not a template — a real plan built from your specific functions, risks, and team structure.

## What You Get

- **Business Impact Analysis** with RTOs and RPOs for every critical function
- **Risk Register** scored by likelihood × impact
- **Recovery Strategies** per function (primary, backup, manual workaround)
- **Communication Plan** with escalation triggers and contact trees
- **IT Disaster Recovery** procedures
- **Testing Schedule** (tabletop, simulation, full DR)
- One clean markdown document ready for PDF export or stakeholder review

## Quick Start

Install in OpenClaw, then:

```
"Create a business continuity plan for our company"
"We're a 30-person agency running on AWS and Google Workspace"
"Map our critical functions and identify single points of failure"
```

## Who It's For

- Operations leads building their first BCP
- CTOs who need DR documentation for compliance (SOC 2, ISO 27001)
- Founders who know they should have a plan but haven't made one
- Anyone preparing for client audits that ask "what's your BCP?"

## Want More?

This is one skill from the [AfrexAI Context Pack collection](https://afrexai-cto.github.io/context-packs/) — pre-built AI agent configurations for specific business functions.

- 🧮 [AI Revenue Leak Calculator](https://afrexai-cto.github.io/ai-revenue-calculator/) — find where your business is bleeding money
- 🚀 [Agent Setup Wizard](https://afrexai-cto.github.io/agent-setup/) — get your AI agent configured in 5 minutes
- 📦 [Full Context Pack Store](https://afrexai-cto.github.io/context-packs/) — $47/pack or bundle deals starting at $97

Built by [AfrexAI](https://afrexai-cto.github.io/context-packs/) — turning operational knowledge into AI agent context.
