# 💰 Budget & Expense Tracker — by AfrexAI

Turn your AI agent into a personal finance command center. Track expenses through natural conversation, enforce budgets automatically, get spending insights, and build toward savings goals — all locally, no external APIs.

## Install

```bash
clawhub install afrexai-budget-tracker
```

## What You Get

- **Natural language expense logging** — "spent $45 on groceries" just works
- **Real-time budget enforcement** — alerts at 75%, 90%, and 100% thresholds
- **Spending pace tracking** — predicts if you'll exceed budget before month-end
- **Savings goals** with auto-contribution and progress tracking
- **Weekly & monthly reports** with category trends and merchant analysis
- **Financial health score** (0-100) across 5 dimensions
- **Smart insights** — day-of-week patterns, subscription audits, optimization suggestions
- **Recurring transaction management** — subscriptions tracked automatically
- **100% local** — your financial data never leaves your machine

## Quick Start

Tell your agent: "I spent $45 on groceries at Aldi"

It logs the transaction, checks your food budget, and alerts you if you're spending too fast.

Ask anytime: "Budget check" → see all categories with pace tracking and projections.

## Why This Over Others?

Most budget skills just log numbers. This one thinks:

- **Pace tracking** tells you you're spending 37% faster than sustainable — not just "you spent $380 of $600"
- **Pattern detection** notices your weekend spending is 40% higher
- **Actionable suggestions** like "move $100 from unused transport budget to savings"
- **Financial health scoring** gives you one number to track over time

## ⚡ Level Up Your Financial Operations

This skill handles personal budgeting. For **business financial automation** — invoicing, cash flow forecasting, revenue tracking, P&L analysis — check out our professional context packs:

- 💼 [SaaS Operations Pack](https://afrexai-cto.github.io/context-packs/) — MRR tracking, churn analysis, unit economics ($47)
- 🏭 [Manufacturing Pack](https://afrexai-cto.github.io/context-packs/) — cost accounting, inventory finance, margin optimization ($47)
- 🏢 [Professional Services Pack](https://afrexai-cto.github.io/context-packs/) — utilization tracking, project profitability, billing ($47)

## 🔗 More Free Skills by AfrexAI

- 📧 [afrexai-email-to-calendar](https://clawhub.com/skills/afrexai-email-to-calendar) — Extract events from emails automatically
- 🎯 [afrexai-lead-hunter](https://clawhub.com/skills/afrexai-lead-hunter) — Find and qualify leads with 100-point scoring
- ✍️ [afrexai-humanizer](https://clawhub.com/skills/afrexai-humanizer) — Make AI content sound human
- 📬 [afrexai-email-triager](https://clawhub.com/skills/afrexai-email-triager) — Smart inbox triage and prioritization
- 🔍 [afrexai-prospect-researcher](https://clawhub.com/skills/afrexai-prospect-researcher) — Deep prospect intelligence

👉 **Full catalog:** [afrexai-cto.github.io/context-packs](https://afrexai-cto.github.io/context-packs/)

---

*Built by [AfrexAI](https://afrexai-cto.github.io/context-packs/) — AI automation that actually works.* 🖤💛
