# Brand Strategy Engine 🖤💛

Complete brand building and go-to-market system — from identity foundations through positioning, messaging, visual systems, and launch execution.

## What This Does

Turns "I need a brand" into a complete, actionable brand system:

- **Brand Foundations** — Purpose, values, personality archetypes, competitive mapping
- **Positioning & Messaging** — April Dunford method, 3-layer messaging architecture, ICP definition
- **Brand Voice** — Writing rules, vocabulary guides, channel-specific tone, content scoring rubric
- **Visual Identity** — Color palettes, typography pairings, logo briefs, imagery guidelines
- **Go-to-Market** — GTM motion selection, launch playbooks, channel strategy, sales battlecards
- **Brand Management** — Health dashboards, quarterly audits, rebrand decision frameworks, crisis playbooks

## Install

```bash
clawhub install afrexai-brand-strategy
```

## Quick Start

Tell your agent:
- "Build my brand identity" → Full walkthrough
- "Write my positioning" → April Dunford positioning method
- "Create messaging for [product]" → 3-layer messaging architecture
- "Plan my GTM" → Complete go-to-market strategy
- "Audit my brand" → Quarterly health check

## What Makes This Different

Most brand skills give you a checklist of "pick your colors." This gives you the **strategic methodology** — archetypes, positioning frameworks, voice scorecards, GTM motion selection, and battlecard templates. 22KB of actionable frameworks, not generic advice.

## ⚡ Level Up

Want industry-specific brand and marketing strategies?

**AfrexAI Context Packs** ($47 each) include tailored positioning, messaging, and competitive analysis for your vertical:

- 🏥 Healthcare AI Context Pack
- ⚖️ Legal AI Context Pack
- 💻 SaaS AI Context Pack
- 🏗️ Construction AI Context Pack
- 🏠 Real Estate AI Context Pack
- 🛒 Ecommerce AI Context Pack
- 💰 Fintech AI Context Pack
- 🏭 Manufacturing AI Context Pack
- 👔 Professional Services AI Context Pack
- 🎯 Recruitment AI Context Pack

👉 **Browse all packs:** https://afrexai-cto.github.io/context-packs/

## 🔗 More Free Skills by AfrexAI

- [afrexai-lead-hunter](https://clawhub.com/skills/afrexai-lead-hunter) — ICP-driven lead generation system
- [afrexai-competitive-intel](https://clawhub.com/skills/afrexai-competitive-intel) — Business competitive intelligence
- [afrexai-proposal-engine](https://clawhub.com/skills/afrexai-proposal-engine) — Deal-winning proposal methodology
- [afrexai-social-media-engine](https://clawhub.com/skills/afrexai-social-media-engine) — Multi-platform content system
- [afrexai-pricing-strategy](https://clawhub.com/skills/afrexai-pricing-strategy) — Complete pricing methodology

---

Built by **AfrexAI** — AI agent infrastructure for businesses that move fast.
