# Board Reporting Framework

Generate investor-ready board decks and reporting packages. Covers monthly board updates, quarterly deep dives, and annual reviews with the metrics that actually matter.

## What This Does

Transforms raw business data into structured board reporting packages:

- **Monthly Flash Report** — 1-page KPI dashboard (ARR, burn, runway, NRR, pipeline)
- **Quarterly Board Deck** — 12-slide structure with benchmarks and narrative
- **Annual Review** — Full-year performance, strategy retrospective, next-year plan
- **Committee Reports** — Audit, compensation, and nominating committee templates
- **Board Meeting Prep** — Pre-read package, agenda, consent items, action tracker

## Metrics Framework

### Financial (Required Every Meeting)
| Metric | Early Stage | Growth | Scale |
|--------|------------|--------|-------|
| ARR/MRR | ✅ | ✅ | ✅ |
| Burn Rate | ✅ | ✅ | ⚠️ |
| Runway (months) | ✅ | ✅ | — |
| Gross Margin | ⚠️ | ✅ | ✅ |
| Net Revenue Retention | — | ✅ | ✅ |
| Rule of 40 | — | ⚠️ | ✅ |
| CAC Payback | ⚠️ | ✅ | ✅ |
| LTV:CAC Ratio | — | ✅ | ✅ |

### Operational
- Logo churn + revenue churn (separate them — boards hate when you hide logo churn)
- Pipeline coverage ratio (3x minimum, 4x healthy)
- Sales efficiency (Magic Number: net new ARR / S&M spend)
- Engineering velocity (ship rate, not story points)
- Headcount plan vs actual

### Strategic
- Market position changes (wins/losses against named competitors)
- Product roadmap delivery rate
- Key hire progress
- Risk register (top 3, with mitigation status)

## Monthly Flash Report Template

```
COMPANY NAME — [Month] [Year] Flash Report

HEADLINE: [One sentence — what happened this month]

KEY METRICS
  ARR:        $X.XM  (↑X% MoM)
  MRR:        $XXK   (↑$XK vs prior)
  Burn:       $XXK   (runway: XX months)
  Cash:       $X.XM
  Customers:  XX     (+X new, -X churned)
  NRR:        XXX%
  Pipeline:   $X.XM  (X.Xx coverage)

WINS THIS MONTH
- [Customer/deal/milestone]
- [Product achievement]

CHALLENGES
- [Issue + what we're doing about it]

ASKS OF THE BOARD
- [Specific help needed — intros, decisions, approvals]
```

## Quarterly Board Deck Structure (12 Slides)

1. **Cover** — Company, date, confidential
2. **Executive Summary** — 3 bullets: what happened, what's working, what needs attention
3. **Financial Overview** — P&L summary, ARR waterfall, burn, runway
4. **ARR Bridge** — New, expansion, contraction, churn (waterfall chart)
5. **Sales & Pipeline** — Win rate, ASP, pipeline coverage, notable deals
6. **Product** — Shipped features, usage metrics, roadmap progress
7. **Customer Health** — NPS/CSAT, churn analysis, expansion revenue
8. **Team** — Headcount, key hires, attrition, culture pulse
9. **Market** — Competitive landscape, market shifts, positioning
10. **Risks & Mitigations** — Top 3-5 risks with status
11. **Strategic Discussion** — The one topic that needs board input
12. **Asks & Next Steps** — Specific board actions needed

## Narrative Rules

- **Lead with the bad news.** Boards respect transparency. Burying problems destroys trust.
- **Compare to plan.** Every metric needs context: vs budget, vs prior quarter, vs benchmark.
- **Skip vanity metrics.** Total signups, page views, "engagement" without definition — leave them out.
- **Use absolute numbers AND percentages.** "Revenue grew 200%" means nothing if it went from $1K to $3K.
- **Three asks maximum.** Boards can act on 3 things. More than that, nothing gets done.

## 2026 SaaS Benchmarks (Board Context)

| Metric | Bottom Quartile | Median | Top Quartile |
|--------|----------------|--------|-------------|
| ARR Growth | <30% | 45% | 80%+ |
| Net Revenue Retention | <100% | 110% | 130%+ |
| Gross Margin | <65% | 75% | 85%+ |
| Burn Multiple | >3x | 1.5x | <1x |
| CAC Payback | >24 mo | 15 mo | <10 mo |
| Magic Number | <0.5 | 0.75 | >1.0 |
| Logo Churn (Annual) | >15% | 8% | <4% |

## Board Meeting Prep Checklist

- [ ] Pre-read sent 5+ business days before meeting
- [ ] Consent agenda items identified (approvals that don't need discussion)
- [ ] Financial package reviewed by CFO/controller
- [ ] One strategic topic identified for deep discussion
- [ ] Customer story prepared (win or loss — rotate)
- [ ] Action items from last meeting — status updated
- [ ] Board dinner/informal time scheduled (relationships matter)

## Anti-Patterns (Things That Get Founders Fired)

1. **Surprise runway crisis** — Board learns about cash problems at the meeting, not before
2. **Metric cherry-picking** — Showing only metrics that went up
3. **No plan for misses** — "We missed target" without "here's what we're changing"
4. **Death by slides** — 40+ slide decks that leave no time for discussion
5. **Avoiding the elephant** — Everyone knows the problem, nobody says it
6. **Asking for nothing** — Boards want to help. Not asking = wasting their network

## Usage

Tell your agent: "Prepare the Q1 board deck" or "Generate the monthly flash report for January" — it will pull your data and structure it using this framework.

## Industry-Specific Board Priorities

| Industry | Key Board Metric | Why |
|----------|-----------------|-----|
| Fintech | Regulatory compliance status | One violation = existential |
| Healthcare | HIPAA audit results | Same |
| SaaS | Net Revenue Retention | Proves product-market fit |
| Construction | Project margin variance | Where money actually goes |
| Ecommerce | Unit economics by channel | Unprofitable channels hide in averages |
| Legal | Utilization rate | Revenue = hours × rate × utilization |
| Real Estate | Portfolio occupancy + NOI | Cash flow is everything |
| Recruitment | Fill rate + time-to-fill | Operational efficiency |
| Manufacturing | OEE + yield rate | Production efficiency |
| Professional Services | Revenue per consultant | Leverage ratio |

---

**Need the full context pack for your industry?** → [AfrexAI Context Packs](https://afrexai-cto.github.io/context-packs/) ($47/pack)

**Calculate your AI automation ROI** → [AI Revenue Leak Calculator](https://afrexai-cto.github.io/ai-revenue-calculator/)

**Set up your agent stack** → [Agent Setup Wizard](https://afrexai-cto.github.io/agent-setup/)

**Bundles:** Pick 3 for $97 | All 10 for $197 | Everything Bundle $247
