# Board Meeting Prep

Generate complete board meeting packages — agenda, financial summary, KPI dashboard, risk register, and action item tracker.

## What This Does

Takes your company context and produces a ready-to-present board package that covers what directors actually care about: cash position, burn rate, revenue trajectory, key risks, and decisions needed.

## How to Use

Tell the agent what you need:

- "Prepare board materials for Q1 review"
- "Generate a board deck covering last quarter's performance"
- "Create an emergency board update on [situation]"

## Board Package Structure

### 1. Executive Summary (1 page max)
- Company health: GREEN / YELLOW / RED
- Cash position and runway (months)
- Revenue vs plan (actual / forecast / variance)
- Top 3 wins since last meeting
- Top 3 risks requiring board attention
- Decisions needed from the board

### 2. Financial Dashboard

```
METRIC              | ACTUAL    | BUDGET    | VARIANCE  | YoY
Revenue             | $___      | $___      | ___%      | ___%
Gross Margin        | ___%      | ___%      | ___pp     | ___pp
Burn Rate           | $___/mo   | $___/mo   | ___%      | ___%
Cash Position       | $___      | $___      | $___      | —
Runway              | ___ mo    | ___ mo    | ___       | —
CAC                 | $___      | $___      | ___%      | ___%
LTV                 | $___      | $___      | ___%      | ___%
LTV:CAC             | ___x      | ___x      | ___       | ___
Net Revenue Ret.    | ___%      | ___%      | ___pp     | ___pp
Headcount           | ___       | ___       | ___       | ___
```

### 3. KPI Deep Dive

**Revenue Breakdown**
- By product line / segment
- New vs expansion vs renewal
- Pipeline coverage ratio (target: 3x)
- Win rate trend (last 4 quarters)

**Customer Health**
- Total customers / net adds
- Churn rate (logo + revenue)
- NPS / CSAT scores
- Top 5 accounts by ARR

**Product & Engineering**
- Features shipped vs planned
- Technical debt ratio
- Uptime / SLA performance
- Roadmap progress (% on track)

### 4. Risk Register

| # | RISK | LIKELIHOOD | IMPACT | MITIGATION | OWNER | STATUS |
|---|------|-----------|--------|------------|-------|--------|
| 1 | | L/M/H | L/M/H | | | Open/Mitigated |
| 2 | | L/M/H | L/M/H | | | Open/Mitigated |
| 3 | | L/M/H | L/M/H | | | Open/Mitigated |

**Risk Categories:**
- Market / competitive
- Financial / cash flow
- Operational / team
- Regulatory / compliance
- Technology / security
- Customer concentration

### 5. Strategic Updates

**Last Quarter Objectives — Scorecard**
| OBJECTIVE | TARGET | ACTUAL | STATUS |
|-----------|--------|--------|--------|
| | | | ✅/⚠️/❌ |

**Next Quarter Objectives**
| OBJECTIVE | METRIC | TARGET | OWNER |
|-----------|--------|--------|-------|
| | | | |

### 6. Decisions Needed

For each decision item:
- **Context:** What happened and why this matters
- **Options:** 2-3 paths with pros/cons
- **Recommendation:** Management's preferred path
- **Timeline:** When decision is needed by
- **Financial impact:** Cost / revenue implications

### 7. Appendix

- Detailed financials (P&L, balance sheet, cash flow)
- Customer list changes (new logos, churned, expanded)
- Hiring plan vs actuals
- Cap table summary (if fundraising)
- Competitive landscape update

## Agenda Template

```
BOARD MEETING AGENDA — [Company] — [Date]

1. Call to Order & Attendance           (5 min)
2. Approval of Previous Minutes         (5 min)
3. CEO Update & Executive Summary       (15 min)
4. Financial Review                     (20 min)
   - P&L walkthrough
   - Cash position & runway
   - Budget variance analysis
5. KPI Dashboard & Metrics              (15 min)
6. Product & Engineering Update         (10 min)
7. Go-to-Market Update                  (10 min)
8. Risk Register Review                 (10 min)
9. Strategic Discussion: [Topic]        (20 min)
10. Decisions & Votes                   (10 min)
11. Action Items & Next Meeting         (5 min)
12. Executive Session (if needed)       (15 min)

TOTAL: ~2 hours 20 minutes
```

## Pre-Meeting Checklist

- [ ] Financial close complete (T-10 days)
- [ ] KPI data pulled and verified (T-7 days)
- [ ] Draft materials to CEO for review (T-5 days)
- [ ] Final materials to board (T-3 days minimum)
- [ ] Calendar invite with Zoom/location confirmed
- [ ] Previous meeting action items status updated
- [ ] Board portal updated (if applicable)
- [ ] Consent agenda items distributed

## Post-Meeting

- [ ] Minutes drafted within 48 hours
- [ ] Action items assigned with deadlines
- [ ] Follow-up materials sent to directors
- [ ] Next meeting date confirmed

## Tips

- Lead with the bad news. Boards hate surprises more than problems.
- One page of insight beats ten pages of data.
- Every metric needs context: vs plan, vs last quarter, vs industry.
- If you need a decision, frame it clearly with options and a recommendation.
- Send materials 3+ days early. Directors who read ahead ask better questions.

---

Need industry-specific board templates? Check out the [AfrexAI Context Packs](https://afrexai-cto.github.io/context-packs/) — $47 each, covering Fintech, Healthcare, Legal, SaaS, and more. Each pack includes sector-specific KPIs, compliance requirements, and benchmarks your board expects to see.

Calculate your AI automation ROI: [Revenue Calculator](https://afrexai-cto.github.io/ai-revenue-calculator/)
Set up your first AI agent: [Setup Wizard](https://afrexai-cto.github.io/agent-setup/)
