# API Monetization Strategy

Turn your internal APIs into revenue streams. This skill helps you evaluate, price, package, and launch API products — whether you're monetizing existing infrastructure or building API-first products from scratch.

## When to Use
- Evaluating which internal APIs have external commercial value
- Designing API pricing (usage-based, tiered, freemium, credits)
- Building developer portals and go-to-market for API products
- Auditing API readiness (rate limiting, auth, SLAs, docs)
- Forecasting API revenue and unit economics

## Framework

### 1. API Asset Audit
Evaluate every internal API against these criteria:

| Factor | Question | Score (1-5) |
|--------|----------|-------------|
| Uniqueness | Does this solve something competitors don't? | |
| Data moat | Does usage improve the product (network effects)? | |
| Rebuild cost | How expensive to replicate from scratch? | |
| Market demand | Are people already scraping/hacking alternatives? | |
| Compliance risk | Any regulatory barriers to external access? | |

**Threshold:** Score ≥18/25 = strong candidate. 13-17 = conditional. <13 = internal only.

### 2. Pricing Models

#### Usage-Based (Pay-per-call)
- Best for: variable consumption, developer experimentation
- Pricing: $0.001-$0.05 per call (commodity) | $0.10-$5.00 per call (enrichment/AI)
- Watch: revenue unpredictability, bill shock complaints

#### Tiered Plans
- Best for: predictable revenue, enterprise sales
- Structure: Free (100 calls/day) → Starter ($49/mo, 10K) → Growth ($199/mo, 100K) → Enterprise (custom)
- Watch: tier boundaries (80% of users should hit limits naturally)

#### Credit-Based
- Best for: multi-endpoint APIs, AI/ML inference
- Structure: Buy credits in bulk, different endpoints cost different credits
- Watch: credit expiry policies, refund complexity

#### Revenue Share
- Best for: marketplace/platform APIs where partner generates revenue
- Structure: 70/30 or 80/20 split on transactions
- Watch: attribution, fraud, minimum guarantees

### 3. Readiness Checklist

**Must-Have Before Launch:**
- [ ] Rate limiting per API key (not just IP)
- [ ] OAuth 2.0 or API key authentication
- [ ] Usage metering accurate to ±0.1%
- [ ] <200ms p95 latency on core endpoints
- [ ] 99.9% uptime SLA (measured, not promised)
- [ ] Versioned endpoints (v1, v2) with deprecation policy
- [ ] Interactive API documentation (OpenAPI/Swagger)
- [ ] Sandbox environment with test data
- [ ] Webhook support for async operations
- [ ] Error responses with actionable messages

**Should-Have for Growth:**
- [ ] SDK in top 3 languages (Python, Node, Go)
- [ ] Usage dashboard for customers
- [ ] Billing alerts at 80%/90%/100% of plan
- [ ] Status page with incident history
- [ ] Community forum or Discord

### 4. Unit Economics

Calculate your API unit economics:

```
Cost per call = (Infrastructure + Support + Compliance) / Total calls
Gross margin = (Revenue per call - Cost per call) / Revenue per call

Target: 70-85% gross margin on API products
```

**Infrastructure cost benchmarks (2026):**
- Simple CRUD: $0.0001-$0.001 per call
- Data enrichment: $0.001-$0.01 per call
- AI/ML inference: $0.01-$0.50 per call
- Real-time streaming: $0.005-$0.05 per minute

### 5. Go-to-Market

**Developer-Led Growth (PLG):**
1. Free tier with generous limits (acquire developers)
2. Docs-first marketing (SEO on "[problem] API")
3. Integration tutorials with popular frameworks
4. Showcase in API marketplaces (RapidAPI, AWS Marketplace)

**Enterprise Sales:**
1. Custom SLAs and dedicated support
2. Private endpoints / VPC peering
3. Volume discounts at commitment (annual contracts)
4. SOC 2 Type II + compliance documentation

**Revenue Forecasting:**
```
Month 1-3: 100-500 free users, 2-5% conversion = 2-25 paid
Month 4-6: 500-2,000 free, 3-7% conversion = 15-140 paid
Month 7-12: Expansion revenue from usage growth (30-50% NRR uplift)
Year 1 target: $50K-$500K ARR depending on market size
```

### 6. Common Mistakes

1. **Pricing too low** — Developers will pay for value. $0.001/call for AI inference is leaving money on the table.
2. **No free tier** — Developers won't commit without testing. Free tier is your acquisition channel.
3. **Breaking changes without versioning** — One breaking change = mass churn. Version everything.
4. **Metering disputes** — If your usage numbers don't match the customer's, you lose trust. Invest in transparent metering.
5. **Ignoring DX** — Time-to-first-call >15 minutes = abandonment. Optimize onboarding ruthlessly.
6. **No rate limiting** — One bad actor takes down your API for everyone. Rate limit from day one.
7. **Bundling everything** — Separate endpoints have different value. Price them differently.

### 7. Industry Applications

| Industry | Highest-Value API | Typical Pricing |
|----------|------------------|----------------|
| Fintech | Transaction scoring, KYC verification | $0.10-$2.00/call |
| Healthcare | Clinical decision support, eligibility | $0.50-$5.00/call |
| Legal | Contract analysis, case law search | $1.00-$10.00/call |
| Real Estate | Valuation, comp analysis | $0.25-$3.00/call |
| Ecommerce | Product matching, pricing intelligence | $0.01-$0.50/call |
| SaaS | Usage analytics, feature flagging | $0.001-$0.05/call |
| Recruitment | Resume parsing, skill matching | $0.10-$1.00/call |
| Manufacturing | Predictive maintenance, quality | $0.50-$5.00/call |
| Construction | Cost estimation, permit lookup | $0.25-$2.00/call |
| Professional Services | Time tracking intelligence, billing | $0.05-$0.50/call |

---

## Resources

- **Full industry context packs** ($47 each): https://afrexai-cto.github.io/context-packs/
- **AI Revenue Calculator** (free): https://afrexai-cto.github.io/ai-revenue-calculator/
- **Agent Setup Wizard** (free): https://afrexai-cto.github.io/agent-setup/
- **Pick 3 Bundle** ($97): Mix any 3 industry packs
- **All 10 Bundle** ($197): Every industry pack
- **Everything Bundle** ($247): All packs + playbook + updates

Built by AfrexAI — turning AI into revenue since 2025.
