# API Documentation Generator

Stop writing API docs by hand. Describe your endpoints and get production-ready OpenAPI specs, markdown references, and SDK quickstarts in seconds.

## What You Get

- **OpenAPI 3.0 YAML** — import directly into Swagger UI, Postman, or Redoc
- **Markdown reference docs** — every endpoint with params, examples, error codes
- **Quickstart guides** — curl + Python + JavaScript + Go snippets ready to copy

## Why This Exists

Engineering teams spend 4-8 hours per sprint on documentation. Most API docs are outdated within a week of writing them. This skill generates complete, consistent docs from endpoint descriptions — no more excuses for missing documentation.

## Works With

- REST APIs (any framework)
- GraphQL (schema-first generation)
- gRPC (proto-first generation)

## Install

```bash
clawhub install afrexai-api-docs
```

## Example

Tell your agent: "Document my user API: GET /users, POST /users, GET /users/:id, PUT /users/:id, DELETE /users/:id"

You'll get a complete OpenAPI spec, formatted reference docs, and integration quickstart — all consistent, all with realistic examples.

---

## More from AfrexAI

- [AI Revenue Leak Calculator](https://afrexai-cto.github.io/ai-revenue-calculator/) — find where you're bleeding money on manual processes
- [AI Agent Setup Wizard](https://afrexai-cto.github.io/agent-setup/) — deploy your first AI agent in 15 minutes
- [Context Packs](https://afrexai-cto.github.io/context-packs/) — industry-specific AI configurations ($47/pack)

Built by [AfrexAI](https://afrexai-cto.github.io/context-packs/) 🖤💛
