# AfrexAI API Architect 🔌

The complete API development lifecycle skill — from design through deployment, monitoring, and versioning.

## What This Does

Turns your AI agent into a senior API engineer. Not just curl commands — a full methodology:

- **Design**: Resource modeling, naming conventions, status code decision trees
- **Spec**: OpenAPI 3.1 generation with quality scoring (0-20 checklist)
- **Build**: Validation layers, error codes, idempotency, rate limiting patterns
- **Test**: Test pyramid, per-endpoint checklists, contract testing, curl recipes
- **Secure**: 30+ point security audit, CORS config, auth patterns
- **Version**: Strategy decision matrix, deprecation playbook, migration templates
- **Monitor**: Metrics dashboard, structured logging, health checks
- **Review**: 100-point API quality rubric across 6 dimensions

## Install

```bash
clawhub install afrexai-api-architect
```

## Quick Start

Tell your agent:
- *"Design a REST API for an order management system"*
- *"Review this API for quality and security issues"*
- *"Generate an OpenAPI spec for my user service"*
- *"Write comprehensive tests for the POST /orders endpoint"*
- *"Security audit our payment API"*

## What Makes This Different

Most API skills give you curl examples. This gives you:
- A **design-first methodology** (spec before code)
- **Decision matrices** (pagination type, versioning strategy, status codes)
- **Scoring rubrics** (spec quality 0-20, API quality 0-100)
- **Production patterns** (idempotency, rate limiting, webhook design)
- **GraphQL guidance** with anti-pattern detection
- **Edge case handling** (timezones, concurrent updates, eventual consistency)

## ⚡ Level Up

Want industry-specific API patterns? Our context packs include API design guidance tailored to your vertical:

- **SaaS Context Pack** — Multi-tenant API design, subscription billing APIs
- **Fintech Context Pack** — Payment processing, PSD2 compliance, ledger APIs
- **Healthcare Context Pack** — FHIR/HL7 integration, HIPAA-compliant endpoints

**[$47 per pack → AfrexAI Store](https://afrexai-cto.github.io/context-packs/)**

## 🔗 More Free Skills by AfrexAI

- [afrexai-code-reviewer](https://clawhub.com/skills/afrexai-code-reviewer) — 60+ pattern code review with SPEAR framework
- [afrexai-data-analyst](https://clawhub.com/skills/afrexai-data-analyst) — DICE framework for data analysis
- [afrexai-business-automation](https://clawhub.com/skills/afrexai-business-automation) — 5-phase automation lifecycle
- [afrexai-seo-content-engine](https://clawhub.com/skills/afrexai-seo-content-engine) — Keyword research to published article
- [afrexai-customer-support](https://clawhub.com/skills/afrexai-customer-support) — HEARD framework + churn prevention

**[Browse all AfrexAI skills →](https://afrexai-cto.github.io/context-packs/)**
