# Annual Report Generator

Build a complete annual business report from raw data. Covers financial performance, operational metrics, strategic highlights, and forward-looking guidance.

## What This Skill Does

Takes your company data and generates a board-ready annual report with:

- **Financial Summary** — Revenue, COGS, gross margin, EBITDA, net income, YoY comparisons
- **Operational Metrics** — Headcount, productivity ratios, customer metrics, unit economics
- **Strategic Review** — Key wins, market position, competitive landscape, risks addressed
- **Forward Guidance** — Next-year targets, strategic priorities, investment thesis, risk outlook

## How to Use

Tell your agent: "Generate our annual report" and provide:

1. **Revenue figures** — Monthly or quarterly, by product/segment if available
2. **Expense data** — By category (payroll, COGS, SGA, R&D)
3. **Customer metrics** — Total customers, churn, NRR, NPS, ARR
4. **Headcount** — Start/end of year, by department
5. **Key milestones** — Product launches, partnerships, funding, market expansion

## Report Structure

### 1. Executive Summary (1 page)
- Year in review headline
- 3-5 key metrics with YoY change
- CEO/founder letter themes

### 2. Financial Performance
| Metric | This Year | Last Year | Change |
|--------|-----------|-----------|--------|
| Revenue | — | — | —% |
| Gross Margin | — | — | —pp |
| EBITDA | — | — | —% |
| Net Income | — | — | —% |
| Cash Position | — | — | — |

**Revenue breakdown** by:
- Product/service line
- Geography
- Customer segment
- New vs expansion vs renewal

**Expense analysis:**
- Cost structure breakdown (% of revenue)
- Headcount cost per employee
- R&D as % of revenue (benchmark: 15-25% for SaaS)
- SGA efficiency ratio

### 3. Operational Review
**Customer metrics:**
- Total customers (start → end)
- Logo churn rate (benchmark: <10% annually)
- Net Revenue Retention (benchmark: >110% for B2B SaaS)
- CAC and LTV with ratio (target: >3x)
- NPS or CSAT scores

**Team metrics:**
- Revenue per employee (benchmark: $200-300K for SaaS)
- Employee satisfaction/eNPS
- Turnover rate (benchmark: <15%)
- Key hires and departures

### 4. Strategic Highlights
- Top 3-5 achievements with business impact
- Product milestones and roadmap delivery
- Market expansion (new segments, geographies)
- Partnership and channel developments
- Brand and thought leadership wins

### 5. Risk Register
| Risk | Likelihood | Impact | Mitigation | Status |
|------|-----------|--------|------------|--------|
| Market contraction | Medium | High | Diversified segments | Monitoring |
| Key person dependency | Medium | High | Cross-training program | In progress |
| Competitive pressure | High | Medium | Innovation velocity | Active |

### 6. Forward Guidance
- Revenue target and growth assumptions
- Key initiatives for next year (max 5)
- Planned investments (headcount, product, market)
- Metrics to watch
- Scenarios: bear / base / bull

## Benchmarks by Company Stage

| Stage | Revenue Growth | Burn Multiple | Rule of 40 |
|-------|---------------|---------------|------------|
| Seed–A | 100-300% | <2x | N/A |
| Series B | 80-150% | <1.5x | >20 |
| Series C | 50-80% | <1x | >30 |
| Growth | 30-50% | <0.8x | >40 |
| Scale | 20-30% | Profitable | >40 |

## Presentation Tips

- **Lead with the story, support with numbers** — Don't dump data. Frame each section around a narrative.
- **Honest about misses** — Credibility comes from acknowledging what didn't work.
- **Forward-looking > backward-looking** — Investors care more about where you're going.
- **Consistent formatting** — Same metrics, same definitions, year over year.
- **One page per section** — Force prioritization. If it doesn't fit one page, it's not tight enough.

## Useful Formulas

```
Gross Margin = (Revenue - COGS) / Revenue
EBITDA Margin = EBITDA / Revenue
Rule of 40 = Revenue Growth % + EBITDA Margin %
Burn Multiple = Net Burn / Net New ARR
Magic Number = Net New ARR / Prior Quarter S&M Spend
CAC Payback = CAC / (ARPA × Gross Margin)
LTV = ARPA × Gross Margin / Monthly Churn Rate
```

---

Built by [AfrexAI](https://afrexai-cto.github.io/context-packs/) — AI context packs that make your agents actually useful.

**Get the full toolkit:**
- [AI Revenue Calculator](https://afrexai-cto.github.io/ai-revenue-calculator/) — Find where you're losing money
- [Agent Setup Wizard](https://afrexai-cto.github.io/agent-setup/) — Deploy your first AI agent in 15 minutes
- [Context Packs Store](https://afrexai-cto.github.io/context-packs/) — Industry-specific agent intelligence ($47/pack)
