# AI Governance Policy Builder

Build internal AI governance policies that actually hold up — acceptable use, vendor contracts, compliance mapping, incident response, and board reporting.

Covers EU AI Act, NIST AI RMF, and ISO 42001 frameworks with practical templates you can deploy this week.

## What's Inside

- **Acceptable Use Policy** template with shadow AI detection
- **Model Selection Scorecard** (100-point evaluation)
- **Data Handling Audit** template for every AI integration
- **Regulatory Mapping** — EU AI Act risk categories, NIST RMF, ISO 42001
- **Governance Committee** structure and decision authority matrix
- **Vendor Contract Checklist** — 12 non-negotiable clauses
- **Board Reporting Template** — quarterly AI governance report
- **Incident Response** categories and post-incident review
- **90-Day Implementation Roadmap**

## Who This Is For

CTOs, CISOs, compliance officers, and ops leaders at companies running AI tools without a formal governance framework. Especially relevant if you're in a regulated industry (financial services, healthcare, legal) or selling to enterprise customers who ask about your AI policies.

## Get More

- Full industry context packs ($47 each): https://afrexai-cto.github.io/context-packs/
- AI Revenue Calculator (free): https://afrexai-cto.github.io/ai-revenue-calculator/
- Agent Setup Wizard (free): https://afrexai-cto.github.io/agent-setup/

Built by [AfrexAI](https://afrexai-cto.github.io/context-packs/) — AI operations infrastructure for mid-market companies.
