# AI Coding Toolkit ⚡

> Master every AI coding assistant — Cursor, Windsurf, Cline, Aider, Claude Code, GitHub Copilot. Tool-agnostic principles that 10X your development speed.

## What This Skill Does

Turns your AI coding assistant from a fancy autocomplete into a systematic development multiplier. Covers:

- **Tool selection matrix** — which AI tool for which task, with decision tree
- **Context engineering** — the #1 skill for AI code quality (rules files, context management, freshness)
- **SPEC prompt framework** — structured prompts that get 10X better output
- **5 workflow patterns** — TDD-AI, Scaffold→Fill→Review, Conversation Threading, Pair Programming, Autonomous Agent
- **Tool-specific power moves** — Cursor, Windsurf, Cline, Aider, Claude Code deep dives
- **Code quality guardrails** — Trust-But-Verify checklist, common AI failures, 3-Read Review
- **Cost optimization** — model routing, token awareness, monthly benchmarks
- **Team adoption playbook** — 3-month rollout plan with guidelines template
- **100-point scoring system** — measure and improve your AI-assisted development

## Install

```bash
clawhub install afrexai-ai-coding-toolkit
```

## Quick Start

1. Tell your agent: "Set up AI coding for my project"
2. It generates a rules file (.cursorrules / CLAUDE.md) tailored to your stack
3. Use the SPEC framework for every prompt
4. Follow the Trust-But-Verify checklist for every AI output

## ⚡ Level Up

This free skill covers methodology. For industry-specific AI agent context packs ($47 each):

- **SaaS Context Pack** — AI agents for SaaS operations, billing, customer success
- **Professional Services Pack** — AI agents for consulting, legal, accounting firms
- **Fintech Context Pack** — AI agents for financial services, compliance, trading

👉 [Browse all context packs](https://afrexai-cto.github.io/context-packs/)

## 🔗 More Free Skills by AfrexAI

- `afrexai-code-reviewer` — 60+ pattern code review with SPEAR framework
- `afrexai-prd-engine` — PRDs optimized for AI coding agents
- `afrexai-technical-docs` — Documentation system with 100-point scoring
- `afrexai-devops-engine` — Complete DevOps & platform engineering
- `afrexai-system-architect` — System architecture methodology

Built by [AfrexAI](https://afrexai-cto.github.io/context-packs/) 🖤💛
