# Agent Memory Architecture 🧠

Complete zero-dependency memory system for AI agents. No APIs, no databases, no external tools — just smart file structures that give your agent perfect recall.

## What This Skill Does

- **5-Layer Memory Architecture** — hot, warm, daily, topic, and archive layers
- **Session Startup Protocol** — what to read and when, optimized for token cost
- **Write-Ahead Protocol** — never lose critical info mid-session
- **Memory Hygiene Schedule** — daily, weekly, monthly, quarterly maintenance
- **Context Window Management** — progressive loading, overflow handling, handoff protocol
- **Heartbeat Integration** — automated memory maintenance during agent wake-ups
- **Security Rules** — what to store, what never to store, privacy in shared contexts
- **Migration Guides** — from no system, from MEMORY.md-only, from external tools

## Install

```bash
clawhub install afrexai-agent-memory-system
```

## Quick Start

```
/memory-status   → Check your memory system health
/memory-review   → Run weekly review and curation
/remember [fact] → Instantly save something important
/handoff         → Prepare for clean session transition
```

## Why Zero Dependencies?

Every other memory skill requires APIs, databases, or cloud services. This one works with plain markdown files. Benefits:

- **$0 cost** — no API calls, no subscriptions
- **Works offline** — no internet required
- **No vendor lock-in** — your files, your control
- **Any framework** — OpenClaw, Cursor, Claude Code, anything
- **Instant setup** — create a few .md files and go

## ⚡ Level Up

Want production-ready agent architectures? Our **$47 Context Packs** include complete agent configurations for your industry:

👉 [Browse Context Packs](https://afrexai-cto.github.io/context-packs/)

## 🔗 More Free Skills by AfrexAI

- [afrexai-agent-engineering](https://clawhub.com/skills/afrexai-agent-engineering) — Complete agent design system
- [afrexai-productivity-system](https://clawhub.com/skills/afrexai-productivity-system) — Personal productivity OS
- [afrexai-prompt-engineering](https://clawhub.com/skills/afrexai-prompt-engineering) — Prompt engineering mastery
- [afrexai-decision-engine](https://clawhub.com/skills/afrexai-decision-engine) — Decision-making frameworks
- [afrexai-technical-docs](https://clawhub.com/skills/afrexai-technical-docs) — Documentation system

---

Built by [AfrexAI](https://afrexai-cto.github.io/context-packs/) 🖤💛
