# AI Agent Manager Playbook

Your company deployed AI agents. Now you need someone to actually manage them.

Harvard Business Review (Feb 2026) calls it the most important new role in business: the **Agent Manager**. Companies without one see 60%+ agent failure rates. Companies with one see 3-4x better outcomes.

This skill gives your AI agent the complete playbook:

- **Agent Performance Scorecard** — 6 dimensions, monthly tracking
- **Lifecycle Framework** — Discovery → Build → Deploy → Optimize
- **Escalation Protocol Design** — 4-level system with trigger definitions
- **Team Structure** — Templates for small, mid-market, and enterprise
- **Governance Framework** — Registry, monthly reviews, quarterly board reports
- **ROI Calculator** — Prove agent value with real math
- **Industry Benchmarks** — ROI ranges across 10 verticals
- **Common Mistakes** — 6 failure patterns and how to avoid them

## Who This Is For

- CTOs and Heads of Engineering deploying AI agents
- Operations leaders managing AI-augmented teams
- Founders building agent-first companies
- Anyone with "AI" in their job title who needs a management framework

## Quick Start

Install this skill, then ask your agent:
- "Audit our current agent portfolio"
- "Create a performance scorecard for our support agent"
- "Design an escalation protocol for our sales agent"
- "Build a quarterly agent ROI report"

---

Built by [AfrexAI](https://afrexai-cto.github.io/context-packs/) — AI context packs that make agents actually useful.

🧮 [AI Revenue Calculator](https://afrexai-cto.github.io/ai-revenue-calculator/) | 🧙 [Agent Setup Wizard](https://afrexai-cto.github.io/agent-setup/)
