# Accounts Receivable Manager

Automate AR aging analysis, collection prioritization, payment follow-ups, and bad debt forecasting with your AI agent.

## Features

- **AR Aging Reports** — 0-30, 31-60, 61-90, 90+ day buckets with risk scoring
- **Collection Priority Queue** — Rank overdue accounts for optimal follow-up
- **Payment Reminder Escalation** — 5-stage email templates from friendly to final notice
- **Cash Application** — Match payments to invoices with variance handling
- **DSO Tracking** — Industry benchmarks for Days Sales Outstanding
- **Bad Debt Forecasting** — Predict write-offs from aging trends

## Why This Matters

- Average SMB has $84,000 in outstanding receivables
- 1 in 4 invoices are paid late
- Every day of DSO improvement = real cash flow impact
- Manual AR processes cost $15-$25 per invoice to manage

## Quick Start

Install this skill in your AI agent, then ask:
- "Run an AR aging report"
- "Prioritize our collection queue"
- "Draft a 60-day overdue reminder for Acme Corp"
- "What's our DSO trend?"

## Take It Further

For full financial operations automation, check out:

- **[AI Agent Context Packs](https://afrexai-cto.github.io/context-packs/)** — Industry-specific configs for Fintech, Professional Services, SaaS ($47 each)
- **[AI Revenue Leak Calculator](https://afrexai-cto.github.io/ai-revenue-calculator/)** — Find where manual processes drain your revenue
- **[Agent Setup Wizard](https://afrexai-cto.github.io/agent-setup/)** — Get configured in minutes

Built by [AfrexAI](https://afrexai-cto.github.io/context-packs/) 🖤💛
