# Accounts Payable Automation Framework

Stop paying $8+ per invoice manually. This skill builds a complete AP automation framework — 3-way matching, approval routing, early payment discount capture, and fraud prevention.

## What It Does

- **Invoice processing pipeline** with OCR validation and duplicate detection
- **Approval routing** by dollar threshold with SLA tracking
- **Payment optimization** — capture 2/10 Net 30 discounts (36.7% annualized return)
- **Vendor management** scorecards and annual review cadence
- **Month-end close** checklist for AP reconciliation
- **Fraud prevention** controls and segregation of duties

## Key Benchmarks

| Metric | Manual | Automated |
|--------|--------|-----------|
| Cost per invoice | $12-$15 | $2-$4 |
| Processing time | 25 days | 3-5 days |
| Exception rate | 30-40% | 5-15% |
| Discount capture | <30% | 75-90% |

A 500-invoice/month company saves $5,000-$6,500/month just on processing costs — plus $15,000-$30,000/year in captured early payment discounts.

## Usage

Tell the agent about your current AP process, invoice volume, vendor count, and pain points. It generates a tailored framework with specific automation recommendations and ROI projections.

## Industry Context Packs

For AP frameworks specific to your industry — regulatory compliance, specialized workflows, and automation ROI calculators:

🛒 **[AI Agent Context Packs](https://afrexai-cto.github.io/context-packs/)** — $47/pack

- **Fintech** — Payment processing compliance, reconciliation
- **Manufacturing** — Complex BOMs, landed cost, 3-way match
- **Construction** — Retention, lien waivers, AIA billing
- **Healthcare** — HIPAA-compliant vendor management

📊 [Revenue Leak Calculator](https://afrexai-cto.github.io/ai-revenue-calculator/) — Find where you're losing money
🤖 [Agent Setup Wizard](https://afrexai-cto.github.io/agent-setup/) — Deploy your AP agent in minutes

**Bundles:** Pick 3 ($97) | All 10 ($197) | Everything Bundle ($247)

---
Built by [AfrexAI](https://afrexai-cto.github.io/context-packs/) — AI agent context for businesses that ship.
