# Orion Design VPS Solutions

This reference lists the tools available for installation via the Orion Design Setup script.

## Core Infrastructure
- **Traefik & Portainer**: Reverse proxy and Docker container management.
- **PgAdmin 4**: PostgreSQL administration tool.
- **MongoDB**: NoSQL database.
- **RabbitMQ**: Message broker.
- **RedisInsight**: Redis GUI.
- **ClickHouse**: Columnar database.

## Automation & AI
- **N8N**: Workflow automation tool.
- **Flowise**: Low-code tool for building LLM apps.
- **Typebot**: Conversational form builder.
- **Botpress**: Chatbot building platform.
- **Dify AI**: LLM application development platform.
- **Ollama**: Run large language models locally.
- **Langflow**: GUI for LangChain.
- **Langfuse**: Tracing and monitoring for LLM apps.
- **Zep**: Long-term memory for AI assistants.

## Communication & CRM
- **Chatwoot**: Open-source customer engagement platform.
- **Evolution API**: WhatsApp API.
- **Uno API**: WhatsApp API.
- **Quepasa API**: WhatsApp API.
- **Mautic**: Marketing automation.
- **Woofed CRM**: CRM platform.
- **TwentyCRM**: Open-source CRM.
- **Mattermost**: Open-source team communication.

## Utilities & Development
- **MinIO**: High-performance object storage.
- **Wordpress**: Content management system.
- **Baserow**: Open-source no-code database.
- **Nocobase**: No-code development platform.
- **Uptime Kuma**: Self-hosted monitoring tool.
- **Cal.com**: Open-source scheduling.
- **Appsmith**: Low-code internal tool builder.
- **Qdrant**: Vector database.
- **Formbricks**: Open-source experience management.
- **NocoDB**: Open-source Airtable alternative.
- **Metabase**: Business intelligence and dashboarding.
- **Odoo**: Suite of business apps (ERP).
- **Docuseal**: Document signing.
- **VaultWarden**: Bitwarden implementation in Rust.
- **NextCloud**: File hosting and collaboration.
- **Strapi**: Headless CMS.
- **PhpMyAdmin**: MySQL administration tool.
- **Supabase**: Open-source Firebase alternative.
- **Ntfy**: Simple HTTP-based pub-sub notification service.
- **LowCoder**: Low-code internal tool builder.
- **OpenProject**: Project management software.
- **HumHub**: Social network software.
- **Yourls**: URL shortener.
- **GLPI**: Asset and IT management.
- **Outline**: Team wiki and knowledge base.
- **Focalboard**: Project management tool.
- **Anything LLM**: Private LLM tool.
- **Excalidraw**: Virtual whiteboard.
- **Easy!Appointments**: Customer appointment scheduler.
- **Documenso**: Digital signature platform.
- **Moodle**: Learning management system.
- **ToolJet**: Low-code internal tool builder.
- **Stirling PDF**: PDF manipulation tool.
- **Traccar**: GPS tracking system.
- **Firecrawl**: Web scraping.
- **Wuzapi**: WhatsApp API.
- **Planka**: Trello-like board.
- **WppConnect**: WhatsApp API.
- **Browserless**: Headless Chrome.
- **Frappe**: Low-code web framework.
- **Bolt**: Project scaffolding.
- **WiseMapping**: Mind mapping.
- **Keycloak**: Identity and access management.
- **Passbolt**: Open-source password manager.
- **Gotenberg**: API for converting documents to PDF.
- **Wiki.js**: Documentation platform.
- **AzuraCast**: Web radio management.
- **Shlink**: URL shortener.
- **RustDesk**: Remote desktop software.
- **Hoppscotch**: API development ecosystem.
