---
name: adwhiz
description: >
  Manage Google Ads & Meta (Facebook) Ads from your AI coding tool. 99 MCP
  tools for auditing, creating, and optimizing ad accounts using natural language.
metadata:
  openclaw:
    primaryEnv: "ADWHIZ_API_KEY"
    requires:
      env:
        - "ADWHIZ_API_KEY"
    homepage: "https://adwhiz.ai"
    source: "https://github.com/iamzifei/adwhiz"
    license: "MIT"
---

# AdWhiz — Google Ads & Meta Ads MCP Server

AdWhiz is a hosted MCP server that connects your AI coding tool to the
Google Ads API and Meta (Facebook) Graph API through a secure, authenticated
proxy. It exposes **99 tools** across 7 categories so you can audit, create,
and manage ad campaigns across both platforms using plain English.

All API calls are authenticated via your personal `ADWHIZ_API_KEY` and routed
through the AdWhiz server at `mcp.adwhiz.ai`. No Google or Meta credentials
are stored by the skill — authentication is handled entirely server-side
after you link your ad accounts at https://adwhiz.ai/connect.

## Security & Permissions Model

- **OAuth 2.0**: User authenticates with Google and/or Meta via AdWhiz's web
  UI. Refresh tokens (Google) and long-lived access tokens (Meta) are encrypted
  at rest (AES-256-GCM) and never exposed to the agent.
- **API key scoping**: Each `ADWHIZ_API_KEY` is bound to a single user's
  connected accounts. Cross-user access is not possible.
- **Write safety**: All Google Ads write tools create entities in **PAUSED**
  status by default. Meta write tools require explicit status parameters.
- **Mutation logging**: Every mutation is recorded in the `get_operation_log`
  tool for full auditability.
- **Read-only by default**: 36 of 99 tools are strictly read-only and cannot
  modify your accounts.
- **Confirmation required**: Write tools require user confirmation before
  executing via the agent's standard permission flow.
- **No arbitrary code execution**: The MCP server is a hosted HTTP service.
  No code is downloaded or executed on the user's machine beyond the thin
  MCP client wrapper.

## Google Ads Tools (70)

### Account (2 tools) — Read-only
| Tool | Description |
|------|-------------|
| `list_accounts` | List all accessible Google Ads accounts |
| `get_account_info` | Get account details (currency, timezone, optimization score) |

### Read (20 tools) — Read-only
| Tool | Description |
|------|-------------|
| `list_campaigns` | List campaigns with status, type, budget, bidding strategy |
| `get_campaign_performance` | Campaign metrics: cost, clicks, conversions, CTR, CPA, ROAS |
| `list_ad_groups` | List ad groups with bids, filtered by campaign |
| `list_ads` | List ads with headlines, descriptions, final URLs |
| `list_keywords` | Keywords with match types, bids, quality scores |
| `get_search_terms` | Search terms report (actual queries triggering ads) |
| `list_negative_keywords` | Negative keywords at campaign, ad group, or account level |
| `list_assets` | Sitelinks, callouts, structured snippets |
| `list_conversion_actions` | Conversion actions with status, type, category |
| `list_budgets` | Campaign budgets with associated campaigns |
| `list_bidding_strategies` | Portfolio bidding strategies |
| `list_audience_segments` | Audience targeting criteria |
| `list_user_lists` | Remarketing/audience lists for targeting |
| `get_operation_log` | Recent mutations performed via AdWhiz |
| `list_recommendations` | Google Ads recommendations (add keywords, raise bids, fix ad strength) |
| `get_change_history` | Change audit log: who changed what and when |
| `list_geo_targets` | Geographic location targeting on campaigns |
| `list_ad_schedules` | Ad schedule (dayparting) criteria on campaigns |
| `list_labels` | Labels for organizing campaigns, ad groups, ads, keywords |
| `generate_keyword_ideas` | Keyword ideas with search volume, competition, bid ranges |

### Write (45 tools) — Requires user confirmation
| Tool | Description |
|------|-------------|
| `create_campaign` | Create Search, Display, PMax, or Video campaign (starts PAUSED) |
| `update_campaign` | Update campaign name |
| `set_campaign_status` | Pause, enable, or remove a campaign |
| `create_ad_group` | Create an ad group in a campaign |
| `update_ad_group` | Update ad group name or CPC bid |
| `set_ad_group_status` | Pause, enable, or remove an ad group |
| `create_responsive_search_ad` | Create RSA with headlines + descriptions (starts PAUSED) |
| `set_ad_status` | Pause, enable, or remove an ad |
| `add_keywords` | Add keywords with match types and bids |
| `update_keyword_bid` | Change a keyword's CPC bid |
| `set_keyword_status` | Pause, enable, or remove a keyword |
| `add_negative_keyword` | Add negative keyword at campaign or ad group level |
| `remove_negative_keyword` | Remove a negative keyword |
| `create_shared_negative_list` | Create a shared negative keyword list |
| `add_to_shared_list` | Add keywords to a shared negative list |
| `attach_shared_list` | Attach shared list to a campaign |
| `create_sitelink` | Create a sitelink asset |
| `create_callout` | Create a callout asset |
| `create_structured_snippet` | Create a structured snippet asset |
| `create_price_extension` | Create a price extension asset |
| `link_asset_to_campaign` | Link asset to a campaign |
| `unlink_asset_from_campaign` | Unlink asset from a campaign |
| `create_conversion_action` | Create a conversion tracking action |
| `update_conversion_action` | Update conversion action name or status |
| `create_budget` | Create a campaign budget |
| `update_budget` | Update budget amount or name |
| `create_bidding_strategy` | Create a portfolio bidding strategy |
| `add_audience_to_campaign` | Add audience targeting to a campaign |
| `update_responsive_search_ad` | Update RSA headlines, descriptions, or URLs |
| `link_asset_to_ad_group` | Link asset to an ad group |
| `unlink_asset_from_ad_group` | Remove asset-to-ad-group linkage |
| `upload_click_conversions` | Upload offline click conversions (gclid-based) |
| `upload_customer_list` | Upload hashed PII to Customer Match user list |
| `apply_recommendation` | Apply a Google Ads recommendation |
| `dismiss_recommendation` | Dismiss a Google Ads recommendation |
| `add_geo_targeting` | Add geographic location targeting to a campaign |
| `remove_geo_targeting` | Remove geographic location target from a campaign |
| `add_ad_schedule` | Add ad schedule (dayparting) to a campaign |
| `remove_ad_schedule` | Remove ad schedule criterion from a campaign |
| `set_device_bid_adjustment` | Set device bid adjustment (mobile, desktop, tablet) |
| `set_demographic_targeting` | Set demographic targeting (age, gender, income) |
| `create_label` | Create a label for organizing entities |
| `apply_label` | Apply a label to a campaign, ad group, or ad |
| `remove_label` | Remove a label from a campaign, ad group, or ad |
| `create_asset_group` | Create an asset group for Performance Max campaigns |

### Audit (2 tools) — Read-only analysis
| Tool | Description |
|------|-------------|
| `run_mini_audit` | Quick 3-metric audit: wasted spend, best/worst CPA, projected savings |
| `run_full_audit` | Comprehensive audit: campaigns, keywords, search terms, issues, recommendations |

### Query (1 tool) — Read-only, bounded
| Tool | Description |
|------|-------------|
| `run_gaql_query` | Execute a read-only GAQL query against your account (max 1,000 rows, SELECT only) |

## Meta (Facebook) Ads Tools (29)

### Meta Read (13 tools) — Read-only
| Tool | Description |
|------|-------------|
| `meta_list_ad_accounts` | List all connected Meta ad accounts |
| `meta_list_campaigns` | List campaigns with status, objective, budget |
| `meta_get_campaign_insights` | Per-campaign metrics: spend, clicks, CTR, CPA, frequency (with optional breakdowns) |
| `meta_list_ad_sets` | List ad sets with targeting, status, budget |
| `meta_list_ads` | List ads with creative details (title, body, image URL) |
| `meta_get_account_insights` | Account-level aggregated metrics with daily breakdown |
| `meta_get_ad_set_insights` | Per-ad-set performance metrics: spend, clicks, CPA, frequency |
| `meta_get_ad_insights` | Per-ad performance metrics: spend, clicks, conversions, CPA |
| `meta_get_ad_creatives` | List ad creatives or get creative for a specific ad |
| `meta_search_interests` | Search targetable interest audiences by keyword |
| `meta_search_geo_locations` | Search geographic locations for targeting |
| `meta_estimate_audience_size` | Estimate reach of a targeting spec |
| `meta_get_account_pages` | List Facebook pages available for running ads |

### Meta Write (15 tools) — Requires user confirmation
| Tool | Description |
|------|-------------|
| `meta_set_campaign_status` | Pause or activate a Meta campaign |
| `meta_update_campaign_budget` | Update a Meta campaign's daily or lifetime budget |
| `meta_set_ad_set_status` | Pause or activate a Meta ad set |
| `meta_set_ad_status` | Pause or activate a Meta ad |
| `meta_create_campaign` | Create a new Meta campaign with objective and budget |
| `meta_create_ad_set` | Create an ad set with targeting, budget, optimization goal |
| `meta_create_ad_creative` | Create ad creative with image/video, link, CTA |
| `meta_create_ad` | Create an ad linking an ad set to a creative |
| `meta_update_campaign` | Update campaign name, budget, end time, spend cap |
| `meta_update_ad_set` | Update ad set name, budget, targeting, schedule |
| `meta_update_ad` | Update ad name, creative, or status |
| `meta_create_custom_audience` | Create custom audience from customer lists or website visitors |
| `meta_create_lookalike_audience` | Create lookalike audience from source audience |
| `meta_upload_ad_image` | Upload image from URL for ad creatives |
| `meta_duplicate_campaign` | Duplicate campaign with all ad sets and ads |

### Meta Audit (1 tool) — Read-only analysis
| Tool | Description |
|------|-------------|
| `meta_run_mini_audit` | Quick health audit: score (0-100) across wasted spend, CPA efficiency, budget utilization, creative fatigue |

## MCP Server Configuration

AdWhiz uses **HTTP transport** to connect to the hosted MCP server. No npm
packages are downloaded or executed at runtime.

```json
{
  "mcpServers": {
    "adwhiz": {
      "transport": "http",
      "url": "https://mcp.adwhiz.ai/mcp",
      "headers": {
        "Authorization": "Bearer ${ADWHIZ_API_KEY}"
      }
    }
  }
}
```

## Quick Install

```bash
clawhub install adwhiz
```

This adds the MCP server configuration above to your settings. You will be
prompted to provide your `ADWHIZ_API_KEY`.

## Getting Your API Key

1. Sign up at https://adwhiz.ai
2. Connect your Google Ads and/or Meta Ads account via OAuth
3. Copy your API key from the dashboard settings page

## Example Prompts

### Google Ads
- "Audit my Google Ads account and show the top 5 waste areas"
- "Pause all campaigns with CPA above $150"
- "Add these negative keywords to my Search campaigns: [list]"
- "Create a new Search campaign targeting lawyers in New York with $100/day budget"
- "Show me search terms wasting money and suggest negatives"
- "What is my account's average Quality Score this month?"

### Meta Ads
- "Audit my Meta Ads account and show the health score"
- "List all active Meta campaigns with their spend and CTR"
- "Pause the Meta campaign with the highest frequency"
- "Show me daily spend trends for my Meta account over the last 30 days"
- "Which Meta ad sets have the worst CPA?"

## Data Handling

- AdWhiz only accesses the ad accounts you explicitly linked
- No campaign data is stored beyond the duration of each API request
- Mutation logs are retained for 30 days for auditability
- You can revoke access at any time from https://adwhiz.ai/connect

## Documentation

Full documentation: https://adwhiz.ai/docs
