---
name: Ads
description: Paid acquisition strategy, budget allocation, and avoiding common advertising mistakes across platforms
metadata:
  category: marketing
  skills: ["ads", "paid-acquisition", "advertising", "ppc", "media-buying"]
---

## Budget Mistakes

- Starting with daily budgets too low to exit learning phase — platforms need 50+ conversions/week per ad set to optimize properly
- Spreading budget across too many campaigns early — concentrate spend to gather statistically significant data faster
- Killing ads before statistical significance — minimum 100 clicks or 1000 impressions before judging creative performance
- No contingency for scaling — reserve 20-30% of budget for doubling down on winners mid-month
- Treating ad spend as expense, not investment — track payback period, not just immediate ROAS

## Metric Traps

- Optimizing for CTR instead of conversion — high CTR with low conversion = curiosity clicks that waste budget
- Trusting platform-reported conversions — attribution windows vary (7-day click, 1-day view), always cross-reference with actual revenue
- Ignoring frequency — above 3-4 frequency per week, performance degrades and audience burns out
- CPA tunnel vision — a $50 CPA is better than $30 CPA if LTV is 3x higher for the $50 cohort
- Vanity reach metrics — 1M impressions mean nothing if 0 target customers saw the ad

## Creative Rules

- One variable per test — changing image AND copy simultaneously teaches nothing about what works
- Winning ads fatigue in 2-4 weeks — have next creative batch ready before performance drops
- Static images often outperform video on cost-per-conversion — test both, don't assume video is better
- Headlines matter more than body copy — 80% of viewers read only the headline
- User-generated content style outperforms polished brand creative in most direct response contexts

## Audience Strategy

- Broad targeting often wins at scale — platform algorithms find converters better than manual interest stacking
- Lookalike audiences need minimum 1000 source users — smaller seeds create unstable lookalikes
- Retargeting pools need 7-14 day recency caps — beyond that, intent has faded
- Exclude converters from prospecting campaigns — paying to show ads to existing customers wastes budget
- Test 1% vs 3% vs 5% lookalikes — tighter isn't always better, depends on market size

## Platform-Specific Patterns

- **Meta**: Learning phase resets with significant edits — avoid editing during first 50 conversions
- **Google**: Search intent beats display reach for direct response — display is for awareness, search is for capture
- **TikTok**: First 3 seconds determine everything — hook must be instant, no slow brand intros
- **LinkedIn**: CPMs are 5-10x higher — only viable for high-LTV B2B where one customer justifies $200+ CPA
- **YouTube**: Skippable ads teach you what hooks work — if they don't skip, your hook is strong

## Scaling Pitfalls

- Increasing budget more than 20-30% per day destabilizes campaigns — gradual scaling preserves algorithm learning
- Duplicating winning ad sets fragments the audience and causes self-competition
- Scaling spend without scaling creative — same ads to larger audience = faster fatigue
- Ignoring incrementality — some conversions would have happened organically, true ROAS is lower than reported
- Geographic expansion without localization — same ad in new market often fails

## Landing Page Impact

- Ads are only half the equation — a 2x better landing page beats 2x more ad spend
- Message match: ad promise must appear above the fold on landing page — disconnect kills conversion
- Page load time over 3 seconds loses 50%+ of paid clicks — optimize speed before scaling spend
- One landing page per audience segment — generic pages convert worse than specific ones
- Track micro-conversions (scroll depth, time on page) when sample size is too small for macro-conversions

## Attribution Reality

- Last-click attribution undervalues awareness campaigns — multi-touch attribution or holdout tests reveal true impact
- iOS 14.5+ broke tracking for ~40% of users — model conversions, don't rely on pixel data alone
- Offline conversions (calls, in-store) need manual import or integration — otherwise CPA looks inflated
- View-through conversions are real but overvalued by platforms — weight click-through higher
- 7-day attribution windows miss longer B2B sales cycles — extend windows or use CRM-based attribution

## Testing Framework

- Always run one control ad — without baseline, you don't know if new creative is better or platform just performed differently
- Minimum 2 weeks per test — weekday/weekend patterns affect results
- Document every test with hypothesis, result, and learning — institutional memory prevents repeat mistakes
- Test audiences before creatives — wrong audience can't be saved by good creative
- Negative results are valuable — knowing what doesn't work prevents future waste
