# Use Cases

## Procurement and vendor selection

Useful criteria:

- cost
- lead time
- quality
- support responsiveness
- contractual risk

Typical constraints:

- maximum budget
- minimum quality threshold
- must exclude vendors without compliance coverage

Recommended policy:

- `risk_averse` for regulated or contract-heavy selections
- `balanced` for standard commercial sourcing

## Hiring shortlist ranking

Useful criteria:

- skill fit
- communication quality
- domain experience
- delivery risk
- compensation

Typical constraints:

- must include language or location requirements
- minimum portfolio or years-of-experience threshold

Recommended policy:

- `risk_averse` when execution risk matters more than upside
- `balanced` for general team-fit comparisons

## Route planning

Useful criteria:

- travel time
- monetary cost
- walking burden
- transfers
- reliability

Typical constraints:

- maximum walking distance
- latest arrival time
- hard budget ceiling

Recommended policy:

- `balanced` for everyday travel
- `risk_averse` when delays or missed arrivals are costly

## Project prioritization

Useful criteria:

- strategic impact
- implementation effort
- revenue potential
- delivery risk
- dependency burden

Typical constraints:

- fixed quarterly capacity
- must include regulatory work

Recommended policy:

- `balanced` for portfolio prioritization
- `exploratory` for early-stage opportunity shaping

## Tool and platform selection

Useful criteria:

- reliability
- setup effort
- maintenance burden
- extensibility
- support quality
- total cost

Typical constraints:

- required on-prem or security posture
- must integrate with current stack
- maximum acceptable migration effort

Recommended policy:

- `risk_averse` for core platform choices
- `exploratory` for sandbox or pilot tooling

## Practical note

ADI works best when the skill helps the user separate:

- preferences, which belong in weights
- hard limits, which belong in constraints
- uncertainty, which belongs in confidence and evidence
