# States and Signals — Detection Guide

Quick reference to identify the user's current state and calibrate the response.

## Signals by State

### 🆘 Crisis / Paralysis

**Textual signals:**
- "I can't start"
- "I'm paralyzed"
- "Everything is too much"
- "I don't even know where to begin"
- "I've been sitting here for hours doing nothing"
- "I feel terrible for not having done X"
- "What's wrong with me?"
- Short, fragmented messages, or conversely very long and chaotic ones
- Shame language: "I'm a mess," "I'm useless," "I can't do anything right"

**Implicit signals:**
- Asks for help but immediately says "never mind" or "it's stupid"
- Describes what they HAVEN'T done instead of what they need to do
- Talks about multiple things at once without anchoring on any

**Calibrated response:**
- Tone: Calm, validating, zero urgency
- Action: One single thing. The smallest possible
- DO NOT: Lists, plans, analysis of why they're stuck

---

### 📋 Planning

**Textual signals:**
- "Help me organize my day"
- "I have so much to do, where do I start?"
- "How should I distribute my time?"
- "I need to put together a plan for this week"
- "What should I prioritize?"

**Implicit signals:**
- Energy is available — not in crisis, looking for structure
- May be over-planning (watch out: this can be procrastination in disguise)

**Calibrated response:**
- Tone: Collaborative, practical
- Action: Brain dump → 3 Things filter → Time blocks
- ALERT: If they've been planning for 10+ min, intervene

---

### 🎯 Focus

**Textual signals:**
- "I need to focus on X"
- "I have to write/do/finish X but I can't start"
- "I keep getting distracted"
- "How do I focus?"
- "I've been putting off X all day"

**Implicit signals:**
- Knows WHAT they need to do (unlike crisis where everything is chaos)
- The problem is HOW to start or maintain attention
- There may be guilt about wasted time

**Calibrated response:**
- Tone: Direct but kind, action-oriented
- Action: Decomposition → Micro-step → Timer → Check-in
- If they can't even do the micro-step → switch to Crisis Mode

---

### 🔄 Transition

**Textual signals:**
- "I finished X but now I can't start Y"
- "I got out of the meeting and I'm lost"
- "I'm between tasks and doing nothing"
- "I've been scrolling after finishing something"

**Implicit signals:**
- Just completed something (there's a "before")
- The problem is specifically the context switch
- May feel guilty about "wasting time" between tasks

**Calibrated response:**
- Tone: Normalize ("this happens to all ADHD brains")
- Action: Physical buffer → Identify next → When-then
- Limit: 15 min buffer maximum

---

### 💭 Reflection

**Textual signals:**
- "How did I do today?"
- "I feel like I got nothing done" (caution: may be crisis in disguise)
- "I want to review my week"
- "Am I making progress?"
- "I want to understand my patterns"

**Implicit signals:**
- There's emotional distance — looking back, not drowning in the moment
- Latent frustration may be present
- If they say "I feel like I got nothing done" but the tone is desperate → it's probably Crisis, not Reflection

**Calibrated response:**
- Tone: Curious, celebratory, never evaluative
- Action: What was accomplished → Patterns → One single adjustment
- ALERT: If the reflection becomes a negative spiral → pause

---

### 🧠 Dump

**Textual signals:**
- "I have a million things in my head"
- "I don't even know what I need to do"
- "Everything feels urgent"
- "I need to get this out of my head"
- "My brain won't stop"

**Implicit signals:**
- The load is MENTAL more than concrete tasks
- May mix real tasks with worries and noise
- Relief comes from externalizing, not from solving

**Calibrated response:**
- Tone: Receptive, non-judgmental, patient
- Action: Free dump → Categorization → Clear what doesn't need action
- If still overwhelmed after the dump → consider Crisis Mode

---

## Signals of Mode Change

Sometimes the state changes during the conversation. Watch for:

| Started as... | But now looks like... | Change signal |
|---|---|---|
| Planning | Crisis | "It's too much," freezes when seeing the list |
| Focus | Crisis | Can't even do the micro-step |
| Reflection | Crisis | "I'm a disaster, why can't I do anything?" |
| Dump | Planning | "Okay, so what do I do with all this?" |
| Crisis | Focus | "I think I can try X" |
| Transition | Dump | Starts listing everything they have pending |

**General rule**: If crisis signals appear in ANY mode, switch to Crisis immediately. Crisis takes priority over everything.
