# Evidence-Based Strategies

Strategies organized by affected executive function. Each includes what it is, why it works, and how to apply it.

## 1. Task Initiation

**The problem**: The ADHD brain has trouble activating. It knows what to do but can't start. It's not laziness — it's a dopamine signaling issue.

### The 2-Minute Rule
- **What**: Commit to only 2 minutes of work, not to finishing
- **Why it works**: Lowers the barrier to entry. Once in motion, the brain often continues (behavioral inertia)
- **How to apply**: "I'm not asking you to finish. Just 2 minutes. If you want to stop after that, you stop."
- **Evidence**: Based on behavioral activation principles (CBT) — behavior precedes motivation, not the other way around

### Body Doubling
- **What**: Working alongside another person (physically or virtually), without needing to interact
- **Why it works**: Another person's presence regulates nervous system arousal and creates passive accountability
- **How to apply**: Suggest Focusmate, study Discords, video call with a friend
- **Evidence**: Research on social behavior regulation and external accountability

### Temptation Bundling
- **What**: Pairing an undesirable task with something pleasurable
- **Why it works**: Injects dopamine into activities the ADHD brain categorizes as "no reward"
- **How to apply**: "What enjoyable thing can you combine with this? Music? A special coffee? Your favorite podcast?"
- **Evidence**: Katherine Milkman's research (Wharton) on incentive bundling

---

## 2. Working Memory

**The problem**: The ADHD brain's RAM is smaller. Things fall out of the mental buffer constantly.

### Total Externalization
- **What**: Get EVERYTHING out of your head onto a physical/digital medium
- **Why it works**: Frees up working memory for the current task instead of using it as a reminder system
- **How to apply**: "If it's not written down, it doesn't exist. Capture it in the moment."
- **Tools**: Quick notes, voice memos, whiteboard, sticky notes in visible places
- **Evidence**: GTD principle (David Allen); research on cognitive load and external offloading

### Checklists for Everything
- **What**: Written lists even for tasks done 100 times before
- **Why it works**: Eliminates the cognitive cost of remembering sequences. Working memory doesn't waste energy on "what's next"
- **How to apply**: Create checklists for morning routines, meeting prep, end-of-day shutdown
- **Evidence**: Atul Gawande's research on checklists; error reduction through cognitive load management

### Written Instructions
- **What**: Document instructions even when they seem obvious
- **Why it works**: ADHD working memory loses intermediate steps. Having a written reference allows reloading context
- **How to apply**: "When someone explains something to you, write it down immediately. Your future self will thank you."

---

## 3. Time Perception

**The problem**: The ADHD brain perceives time non-linearly. "Now" and "not now" are the only functional time categories.

### The 3x Rule
- **What**: Multiply any estimate by 3
- **Why it works**: Compensates for the ADHD brain's systematic temporal optimism
- **How to apply**: Ask "how long do you think it takes?" → multiply by 3 → that's the real number
- **Quick table**:
  - "5 minutes" → 15-20 minutes
  - "30 minutes" → 1-1.5 hours
  - "A couple of hours" → Half a day
  - "This weekend" → Probably won't happen without body doubling

### Visual Timers
- **What**: Use timers that visually show the passage of time (not just numbers)
- **Why it works**: Makes tangible something that feels abstract to the ADHD brain
- **Tools**: Time Timer (visual clock), Pomodoro apps with visual progress
- **Evidence**: Research on visual time representation and ADHD

### Calendar Blocking
- **What**: If something isn't on the calendar with an assigned time, it doesn't exist
- **Why it works**: Converts abstract intentions ("I should do X") into concrete time commitments
- **How to apply**: Every important task goes on the calendar as an event. With realistic duration (3x).

---

## 4. Emotional Regulation

**The problem**: ADHD includes difficulty regulating emotions — intense frustration, disproportionate shame, rejection sensitive dysphoria (RSD).

### Validation Before Solutions
- **What**: Acknowledge the emotion before offering fixes
- **Why it works**: An emotionally activated brain can't process solutions. Validating first reduces activation
- **How to apply**: "That sounds frustrating" / "It's normal to feel that way" → PAUSE → only then: "Want to look at what to do?"
- **Evidence**: Interpersonal emotion regulation principles (Linehan, DBT)

### Active Self-Compassion
- **What**: Treat yourself the way you'd treat a friend in the same situation
- **Why it works**: Self-criticism activates the brain's threat mode, which BLOCKS executive function. Compassion activates safe mode, which ENABLES it
- **How to apply**: "What would you say to a friend who told you this? Say that to yourself."
- **Evidence**: Kristin Neff — research on self-compassion and self-regulation

### Name the Emotion
- **What**: Put an exact name on what you're feeling
- **Why it works**: "Affect labeling" reduces emotional intensity by activating the prefrontal cortex
- **How to apply**: "What are you feeling? Is it frustration, fear, shame, boredom, anxiety?"
- **Evidence**: Lieberman et al. — affect labeling and amygdala reactivity

---

## 5. Decision-Making

**The problem**: Every decision spends executive function. The ADHD brain has a smaller budget and makes thousands of micro-decisions daily.

### Pre-Decide
- **What**: Eliminate recurring decisions with fixed rules
- **Why it works**: Saves executive function for decisions that really matter
- **Examples**:
  - Same breakfast every day (or rotate 2-3 options)
  - Clothes laid out the night before
  - Fixed schedules for types of work
  - "If it's Tuesday, it's admin day"

### Reduce Options
- **What**: Never give more than 2-3 options
- **Why it works**: More options = more paralysis. The paradox of choice affects ADHD brains more
- **How to apply**: Instead of "what do you want to do?", ask "A or B?"

### If-Then Rules
- **What**: Predefined rules that eliminate the need to decide in the moment
- **Why it works**: The decision was already made. You just execute
- **Examples**:
  - "If the timer goes off → I save my work and stand up"
  - "If I get an urgent email → I flag it, I don't reply yet"
  - "If I don't know where to start → I do the smallest thing first"
- **Evidence**: Implementation intentions (Peter Gollwitzer) — reduce the intention-action gap

---

## 6. Transitions

**The problem**: Switching from one task to another requires closing one mental context and opening another. For the ADHD brain, this is especially costly.

### Transition Buffers
- **What**: 10-15 minutes scheduled between tasks
- **Why it works**: Gives the brain time to unload the previous context before loading the new one
- **How to apply**: In the calendar, every work block ends 15 min before the next one

### Closing Rituals
- **What**: A physical action that marks the end of something
- **Why it works**: Creates a clear sensory signal that something is finished — the ADHD brain doesn't generate these signals naturally
- **Examples**: Close the laptop, stand up, say out loud "I'm done," change rooms

### When-Then Statements
- **What**: Connect the end of something to the beginning of what's next
- **Why it works**: Uses momentum instead of requiring new activation
- **How to apply**: "When I finish my coffee → I open the doc. When I close the meeting → I write my notes."
- **Evidence**: Behavioral chaining — each action is the trigger for the next one

---

## Note on Medication

This skill is not medical and does not have opinions on medication. If the user mentions medication:
- Never suggest starting, changing, or stopping medication
- Acknowledge it's a valid tool
- Suggest talking to their healthcare professional
- Remind that these strategies are COMPLEMENTARY, not substitutes
