# Time-Blindness Friendly Planning ⏰

## The Problem

ADHD brains often:
- Can't estimate how long things take
- Lose track of time completely (hyperfocus)
- Feel time as "now" or "not now"
- Get stressed by rigid schedules
- Miss appointments because we can't "feel" time passing

## The Solution: Relative Time

### No Clock Times
❌ "Email at 9am"  
✅ "Email (morning block)"

❌ "Meeting at 2pm"  
✅ "Meeting (afternoon)"

❌ "Work on project 10-12"  
✅ "Work on project (high energy)"

### Time Markers We Use

| Marker | Meaning | Typical Range |
|--------|---------|---------------|
| 🌅 Morning | First thing | 6am - 11am |
| ☕ Mid-morning | After settling in | 9am - 12pm |
| 🌞 Midday | Lunch-adjacent | 11am - 2pm |
| 🌤️ Afternoon | Post-lunch | 1pm - 6pm |
| 🌙 Evening | Winding down | 5pm - 10pm |
| 🦉 Night | Night owls | 9pm - 2am |

### Duration Estimates (Not Timestamps)

| Symbol | Duration | Use For |
|--------|----------|---------|
| ⚡ | 5 min | Quick wins |
| ⏱️ | 15 min | Short tasks |
| 🕐 | 30 min | Medium tasks |
| ⏳ | 60+ min | Deep work |

Example:
```
- [ ] ⚡ Check email (5 min)
- [ ] ⏱️ Review proposal (15 min)
- [ ] 🕐 Team meeting (30 min)
- [ ] ⏳ Write report (60+ min)
```

## Transition Buffers

ADHD brains need time to switch contexts.

**Always add buffers between different types of tasks:**

```
Before: Deep work → Meeting (jarring!)
After:  Deep work → 5 min buffer → Meeting

Buffer activities:
- Stand up and stretch
- Get water
- Bathroom break
- Quick walk
- Write down where to resume
```

## The "Time Anchor" Technique

When you MUST be somewhere at a specific time:

1. **Set multiple alarms:**
   - 30 min before (start wrapping up)
   - 15 min before (save work, prepare)
   - 5 min before (shoes on, leaving)
   - At time (GO NOW)

2. **Use external time markers:**
   - "After lunch" instead of "1pm"
   - "When the sun sets" (if applicable)
   - "After this meeting"

3. **Visual timers:**
   - Physical hourglass
   - Timer app with visual display
   - Analog clock (easier to "see" time)

## Energy Mapping

Instead of scheduling by clock time, schedule by energy:

```
My Energy Pattern:
🌅 Morning: 🔥 High (do hard stuff)
☕ Mid-morning: 💧 Medium (calls, email)
🌞 Midday: ❄️ Low (admin, easy tasks)
🌤️ Afternoon: 💧 Medium (standard work)
🌙 Evening: 🔥 High (second wind for deep work)

NOT:
9am - Email
10am - Deep work
11am - Calls

BUT:
🌅 Morning: Deep work
☕ Mid-morning: Calls + Email
🌞 Midday: Admin
```

## The "Not Now" Problem

ADHD brains see time as:
- **Now** - I can act on this
- **Not Now** - Doesn't exist

**Solution: Bring future tasks into "now"**

Instead of: "Meeting at 3pm" (not real until 2:55pm)  
Use: "Meeting is NEXT after current task"

Instead of: "Deadline Friday" (not real until Thursday panic)  
Use: "Deadline is in 3 work blocks" (count work sessions)

## Time-Blindness Hacks

1. **Body-based timing:**
   - "After I finish this coffee"
   - "After 3 bathroom breaks"
   - "When I get hungry"

2. **Task-based timing:**
   - "After 5 emails"
   - "After this document"
   - "After one pomodoro"

3. **Visual schedules:**
   - Color-coded blocks
   - Pictures instead of text
   - Physical objects moved as progress

4. **External accountability:**
   - Tell someone your plan
   - Body doubling for time checks
   - Phone a friend at transition times

## The Planner's Promise

**This planner will never:**
- ❌ Shame you for "missing" a time slot
- ❌ Require rigid adherence to schedules
- ❌ Assume you can estimate time accurately
- ❌ Make you feel bad for time blindness

**This planner will:**
- ✅ Suggest tasks based on energy, not clock time
- ✅ Remind you gently of time passing
- ✅ Help you batch similar tasks
- ✅ Celebrate completion, not punctuality
