# Rapid Logging Reference

## Core Symbols

| Symbol | Name | Usage |
|--------|------|-------|
| `•` | Task | Anything actionable |
| `×` | Completed | Task is done |
| `>` | Migrated | Moved to future log/tomorrow |
| `<` | Scheduled | Specific date/time set |
| `–` | Note | Information only |
| `○` | Event | Happening (immutable) |

## Priority & Energy

| Symbol | Meaning |
|--------|---------|
| `★` | Must happen today (THE ONE thing) |
| `☆` | If-energy (nice to have) |
| `!` | Urgent/time-sensitive |
| `?` | Waiting (blocked) |
| `💀` | Dread task (needs support) |

## Signifiers (Left Margin)

| Signifier | Meaning |
|-----------|---------|
| `*` | Inspiration/idea |
| `!` | Priority |
| `@` | Location-based |
| `$` | Revenue/money impact |
| `→` | Delegated |

## Examples

```
Daily Log:
  ★ Write newsletter
  • Call dentist
  • Review proposal
  ! Respond to urgent email
  ? Waiting on John's feedback
  💀 Prepare taxes
  × Completed task
  > Migrated to tomorrow
  < Scheduled for 2026-02-15
  – Note: Client prefers morning calls
  ○ Team meeting at 2pm
  @ Pick up dry cleaning
  $ Send invoice
```

## Migration Rules

**Daily → Tomorrow**: `>` (still relevant, not urgent)  
**Daily → Future**: `<` (specific date planned)  
**Daily → Dropped**: ~~strikethrough~~ (admit it's not happening)  

**Migration is strategic prioritization, not failure.**
