# Swim Lanes Explained 🏊

## Why Swim Lanes?

ADHD brains are **time-blind** - we can't feel time passing. Traditional planners with time slots (9am, 10am, etc.) don't work because:
- We ignore them
- We feel like failures when we miss them
- They don't account for energy fluctuations

**Swim lanes are context-based, not time-based.**

## The Default Lanes

### 🎯 MUST HAPPEN
- **Only ONE thing goes here**
- The task that makes today a success
- Gets first dibs on high-energy time
- Everything else is bonus

### 🔥 HIGH ENERGY
- Deep work requiring focus
- Creative tasks
- Difficult conversations
- Complex problem-solving

**When to use:** Morning, post-exercise, high dopamine moments

### 💧 MEDIUM ENERGY
- Standard work tasks
- Routine emails
- Calls and meetings
- Administrative work

**When to use:** Default lane for most of the day

### ❄️ LOW ENERGY
- Easy wins
- Mindless admin
- Organizing
- Data entry

**When to use:** Afternoon slump, evening, low sleep

### 🚫 NOT TODAY
- Captured but deferred
- Important but not urgent
- Ideas for future

**When to use:** During rapid log when you realize it can't happen today

## Custom Swim Lanes

Create your own based on your life:

### By Context
- `@calls` - All phone calls (batch them!)
- `@computer` - Desk-only work
- `@errands` - Out-of-house tasks
- `@home` - Chores, personal

### By Impact
- `$revenue` - Money-generating activities
- `$growth` - Learning, skills
- `$maintenance` - Keeping things running

### By Mood
- `😊 fun` - Tasks you enjoy
- `💀 dread` - Tasks you're avoiding
- `🤝 social` - People-facing tasks

## Lane Switching

**You can move tasks between lanes!**

Example:
```
Started day:
  🔥 HIGH ENERGY: Write proposal

2pm energy crash:
  Move "Write proposal" to 💧 MEDIUM ENERGY
  Work on ❄️ LOW ENERGY: Email cleanup

Evening second wind:
  Move "Write proposal" back to 🔥 HIGH ENERGY
```

## Lane Selection Strategy

**Check your energy, then pick the lane:**

| Energy Level | Recommended Lane |
|--------------|------------------|
| 8-10 | 🔥 HIGH ENERGY (tackle hard stuff) |
| 5-7 | 💧 MEDIUM ENERGY (standard work) |
| 3-4 | ❄️ LOW ENERGY (easy wins only) |
| 1-2 | 🚫 NOT TODAY (rest, try again tomorrow) |

## The ONE Thing Rule

**🎯 MUST HAPPEN can only have ONE task.**

If you think two things must happen, ask:
- "If only ONE happens, which matters more?"
- "Which has a deadline today?"
- "Which unblocks other work?"

Everything else goes in other lanes.

## Lane Batching

**Try to do multiple tasks from the same lane together:**

Instead of:
- Email (💧)
- Code (🔥)
- Email (💧)
- Call (💧)

Do:
- Email, Email, Call (all 💧)
- Then Code (🔥)

Less context switching = better ADHD focus.
