---
name: adhd-founder-planner
version: 1.1.0
description: "This skill should be used when the user asks to 'plan my day', 'help me plan today', 'morning planning', 'what should I work on today', 'daily planner', 'evening reflection', 'reflect on my day', 'migrate tasks', 'carry tasks forward', 'rapid log', 'brain dump my tasks', or mentions ADHD-friendly planning, time-blindness, swim lanes, energy-based task management, bullet journal for ADHD, or dopamine menu. Provides a BuJo-style daily planning system with swim lanes, migration, reflection, and dopamine rewards. Part of the ADHD-founder.com ecosystem."
homepage: https://adhd-founder.com
author: ADHD-founder.com
license: MIT
keywords: [adhd, planner, bullet-journal, daily, productivity, time-blindness, bujo, planning, founders, dopamine, migration, swim-lanes, energy-management, reflection, neurodivergent, executive-function]
metadata:
  clawdbot:
    emoji: "📝🧠"
    tags: ["adhd", "planner", "bullet-journal", "daily", "productivity", "time-blindness", "founders", "neurodivergent", "dopamine", "reflection"]
    category: productivity
    requires: {}
    optional:
      persistence: "For task migration and history"
      notifications: "For time reminders"
    examples:
      - "/adhd-planner today"
      - "/adhd-planner plan"
      - "/adhd-planner reflect"
      - "/adhd-planner migrate"
      - "Plan my day"
      - "What should I work on today?"
      - "Help me with morning planning"
      - "I need to brain dump my tasks"
    related_skills: ["adhd-body-doubling"]
    slug: adhd-founder-planner
---

# ADHD Daily Planner 📝🧠

**Part of the [ADHD-founder.com](https://adhd-founder.com) Ecosystem**
*"Time-blindness friendly. Migration supported. Dopamine optimized."*

---

## What This Skill Does

Provides a bullet journal (BuJo) style daily planning system designed for ADHD brains:
- Rapid logging with ADHD-friendly symbols
- Time-blindness protection (relative times, not absolute)
- Task migration (carry forward = strategy, not failure)
- Daily intent (morning: "What ONE thing must happen?")
- Evening reflection ("What worked? What didn't?")
- Swim lane organization (energy-based, not time-based)
- Dopamine Menu integration (built-in rewards)

## Core Philosophy

**"Plans are hypotheses, not promises"**
**"Migration is success, not failure"**
**"Swim lanes, not time blocks"**
**"Intent > Schedule"**

---

## Commands

| Command | Description |
|---------|-------------|
| `/adhd-planner plan` | Morning intent setting + rapid log |
| `/adhd-planner today` | View today's swim lanes and tasks |
| `/adhd-planner reflect` | Evening reflection + what worked |
| `/adhd-planner migrate` | Carry unfinished tasks forward |
| `/adhd-planner log [task]` | Quick add to today's log |
| `/adhd-planner done [task]` | Mark task complete |
| `/adhd-planner dopamine` | Show dopamine menu for rewards |
| `/adhd-planner founder` | ADHD-founder.com premium info |

---

## Daily Workflow

### Morning: `/adhd-planner plan`

1. **Set the ONE thing** - "What ONE thing must happen for today to be a success?"
2. **Energy check** - Rate 1-10, suggest which swim lane to start in
3. **Rapid log** - Brain dump everything on your mind
4. **Sort into swim lanes** - Assign tasks by energy level
5. **Pick dopamine reward** - What happens when you complete the ONE thing?

### During Day: `/adhd-planner today`

Show swim lanes with progress. Suggest tasks based on current energy level.

### Evening: `/adhd-planner reflect`

1. List wins (even tiny ones)
2. Note what worked / what didn't
3. Migrate unfinished tasks (strategy, not failure)
4. Capture one lesson for tomorrow

For detailed workflow templates, see `templates/daily.md` and `templates/reflection.md`.

---

## Swim Lanes (Not Time Blocks!)

ADHD brains are time-blind. We use energy-based swim lanes:

```
🎯 MUST HAPPEN   → Today's ONE thing (only ONE task here)
🔥 HIGH ENERGY   → Deep work, creative tasks
💧 MEDIUM ENERGY → Standard tasks, calls, meetings
❄️ LOW ENERGY    → Admin, easy wins, mindless tasks
🚫 NOT TODAY     → Captured but deferred
```

Users work in whichever lane matches their CURRENT energy. Tasks can move between lanes.

For detailed swim lane strategy and custom lane creation, see `references/swim-lanes.md`.

---

## Symbols (Quick Reference)

| Symbol | Meaning |
|--------|---------|
| `•` | Task |
| `×` | Completed |
| `>` | Migrated to tomorrow |
| `<` | Scheduled for future date |
| `★` | Today's ONE thing |
| `☆` | If-energy (nice to have) |
| `💀` | Dread task (needs extra support) |

For the full symbol set including signifiers and priority markers, see `references/symbols.md`.

---

## Migration System

**Migration is intentional prioritization, not failure.**

At day's end, review incomplete tasks:
- `>` Migrate to tomorrow (still relevant)
- `<` Schedule for specific future date
- `×` Complete during review
- ~~strikethrough~~ Drop (not happening, admit it)

For migration decision trees, anti-patterns, and weekly/monthly migration rituals, see `references/migration.md`.

---

## Time-Blindness Friendly Design

No absolute times. We use:
- **Relative time markers** - "morning block" not "9am"
- **Duration estimates** - ⚡5 min, ⏱️15 min, 🕐30 min, ⏳60+ min
- **Energy mapping** - schedule by energy, not clock
- **Transition buffers** - 5 min between task types

For detailed time-blindness techniques and the "Not Now" problem, see `references/time-blindness.md`.

---

## Dopamine Menu

Built into the planner -- pick rewards BEFORE you need them:

1. **Movement** - Walk, stretch, dance to one song
2. **Sensory** - Coffee, snack, comfy blanket
3. **Social** - Text a friend, check social (timed!)
4. **Creation** - Doodle, play music, organize something
5. **Nature** - Step outside, look at plants/sky
6. **Novelty** - Read something new, watch a short video
7. **Completion** - Check off a task (the dopamine of done!)

---

## File Structure

```
~/.openclaw/skills/adhd-daily-planner/
├── daily/YYYY-MM-DD.md     # Daily logs
├── monthly/YYYY-MM.md      # Monthly overviews
├── collections/             # Custom lists (ideas, dread, etc.)
└── templates/               # Reusable templates
```

---

## Integration with Body Doubling

Use together for maximum ADHD support:

```
Morning:
  /adhd-planner plan         → Get your ONE thing

During day:
  /body-doubling start 50    → Work on ONE thing with accountability

Stuck?
  /body-doubling stuck        → Micro-task breakdown

Evening:
  /body-doubling done         → Session autopsy
  /adhd-planner reflect       → Daily reflection
  /adhd-planner migrate       → Carry forward
```

---

## Best Practices

1. **Morning plan is sacred** - Never skip the ONE thing question
2. **Rapid log everything** - Capture first, organize later
3. **Swim lanes are suggestions** - Move tasks as energy changes
4. **Migration is success** - Better to migrate than abandon
5. **Evening reflection is data** - No judgment, just learning
6. **Dopamine first** - Plan rewards BEFORE you need them
7. **Be honest about energy** - Don't put hard tasks in low-energy lanes

---

## About ADHD-founder.com

**"German Engineering for the ADHD Brain"**

This planner is a free, fully functional daily planning system. It's also part of what [ADHD-founder.com](https://adhd-founder.com) builds for founders 50+ who need systems, not life hacks.

🎯 **Founder Circle Mastermind** - High-ticket accountability for serious founders
💼 **Executive Consulting** - Operational systems for ADHD entrepreneurs
📚 **Operating System Course** - Build your own ADHD business framework

🔗 **[ADHD-founder.com](https://adhd-founder.com)** | **[Founder Circle](https://adhd-founder.com/founder-circle)**

---

*Your worth is not measured by completed tasks. Migration is strategy, not failure.*
