# Executive Function Toolkit

Practical tools and strategies for managing ADHD executive function challenges.

## The Executive Functions

```
┌─────────────────────────────────────────────────────────────────┐
│                    EXECUTIVE FUNCTIONS                          │
├─────────────────────────────────────────────────────────────────┤
│                                                                 │
│  WORKING MEMORY          COGNITIVE FLEXIBILITY                  │
│  Holding info in mind    Shifting between tasks                 │
│  Following instructions  Adapting to changes                    │
│  Mental math             Seeing different perspectives          │
│                                                                 │
│  INHIBITION              TASK INITIATION                        │
│  Stopping impulsive      Starting tasks without                 │
│  responses               external pressure                      │
│  Waiting your turn       Overcoming inertia                     │
│                                                                 │
│  EMOTIONAL REGULATION    PLANNING/PRIORITIZATION                │
│  Managing frustration    Sequencing steps                       │
│  Controlling reactions   Identifying what matters               │
│  Self-soothing          Time management                         │
│                                                                 │
│  ORGANIZATION            SELF-MONITORING                        │
│  Tracking belongings     Checking your work                     │
│  Maintaining systems     Awareness of performance               │
│  Physical/digital order  Adjusting approach                     │
│                                                                 │
└─────────────────────────────────────────────────────────────────┘
```

## Task Initiation Strategies

### The 2-Minute Start Protocol
```
I will work on [task] for exactly 2 minutes.
After 2 minutes, I can stop with no guilt.

STEPS:
1. Set a timer for 2 minutes
2. Start the SMALLEST possible action:
   - Open the document
   - Write one sentence
   - Send one email
   - Sort one item
3. When timer ends, ask: "Do I want to continue?"
4. If yes: continue. If no: stop. Both are wins.
```

### Task Initiation Menu
When you can't start, pick ONE:

| Strategy | When to Use | How |
|----------|-------------|-----|
| **Body Double** | Need accountability | Focusmate, friend on video, café |
| **Temptation Bundle** | Task is boring | Pair with podcast/music/snack |
| **Reduce Friction** | Setup feels overwhelming | Pre-stage materials night before |
| **Change Location** | Stuck in one spot | New room, café, library |
| **Time Box** | Task feels endless | "25 min only, then done for today" |
| **Gamify** | Need dopamine | Points, streaks, rewards |
| **Worst First** | Anxiety about task | Do hardest thing first, rest is easy |
| **Eat the Frog Adjacent** | Can't face hardest | Do second-hardest to build momentum |

### The 5-4-3-2-1 Launch
```
5 - Acknowledge: "I need to start [task]"
4 - Locate: Find what you need
3 - Prepare: Open/arrange materials
2 - Clear: One small distraction removal
1 - GO: First physical action, no thinking

COUNT OUT LOUD: "Five, four, three, two, one, GO."
Then MOVE. Don't wait for motivation.
```

## Working Memory Supports

### The Capture System
Every thought gets captured IMMEDIATELY in ONE of these:

```
PHYSICAL                    DIGITAL
┌─────────────────┐        ┌─────────────────┐
│ Pocket notebook │        │ Notes app       │
│ (always on you) │        │ Voice memo      │
│                 │        │ Quick capture   │
└─────────────────┘        └─────────────────┘
         │                          │
         └──────────┬───────────────┘
                    ▼
          WEEKLY: Process into
          ┌─────────────────────┐
          │ Calendar / Todo     │
          │ Reference files     │
          │ Trash (most of it)  │
          └─────────────────────┘
```

### External Memory Systems

**For Tasks:**
```
TODAY (visible - whiteboard/sticky note)
├── THE Thing: [Most important]
├── Would Be Nice: [Important but not critical]
└── If Crushing It: [Bonus]

WEEK (digital - simple todo app)
├── Monday: [Key deliverable]
├── Tuesday: [Key deliverable]
└── ...

SOMEDAY (digital - separate list)
├── Ideas without deadlines
└── Review monthly
```

**For Information:**
```
BRAIN DUMP FILE (one document, append only)
├── Meeting notes
├── Random thoughts
├── Things to remember
└── Searchable by date

REFERENCE SYSTEM (folders by project/topic)
├── Project A/
├── Project B/
└── Reference/
```

### The "If-Then" Implementation
Pre-decide responses to reduce working memory load:

```
IF [trigger]              THEN [action]
──────────────────────────────────────────
I finish a meeting      → Write 3 bullet summary immediately
I have an idea          → Voice memo, not "I'll remember"
I'm asked for deadline  → "Let me check and get back to you"
I'm overwhelmed         → Brain dump onto paper first
I'm avoiding a task     → Ask "What's the smallest step?"
Email arrives           → Process at 10am/2pm/4pm ONLY
```

## Time Management Tools

### Time Blocking for ADHD
```
┌─────────────────────────────────────────────────────────────┐
│ MORNING (Protect for deep work if that's your peak)        │
├─────────────────────────────────────────────────────────────┤
│ 9:00  │ THE Thing (no meetings, notifications off)         │
│       │ [Use body double, website blocker, timer]          │
│ 10:30 │ ▓▓▓ TRANSITION BUFFER (15 min) ▓▓▓                 │
│ 10:45 │ Meetings / collaborative work                      │
├─────────────────────────────────────────────────────────────┤
│ MIDDAY (Energy dip - don't fight it)                       │
├─────────────────────────────────────────────────────────────┤
│ 12:00 │ LUNCH (actual break, not working)                  │
│ 12:45 │ Low-cognitive tasks: email, admin, filing          │
│       │ [This is when to do easy stuff]                    │
├─────────────────────────────────────────────────────────────┤
│ AFTERNOON (Second wind for some)                           │
├─────────────────────────────────────────────────────────────┤
│ 2:00  │ Collaborative work, meetings, variety              │
│ 4:00  │ Shutdown ritual (5 min - non-negotiable)           │
└─────────────────────────────────────────────────────────────┘

▓▓▓ = Non-negotiable buffer time
```

### Time Estimation Worksheet
```
TASK: ________________________________

My gut estimate: _____________ minutes/hours

REALITY CHECK:
┌─────────────────────────────────────────────────────────────┐
│ My estimate    │ Multiply by │ Realistic estimate           │
├─────────────────────────────────────────────────────────────┤
│ 5 minutes      │     3x      │ 15 minutes                   │
│ 30 minutes     │     3x      │ 1.5 hours                    │
│ 1 hour         │     2x      │ 2 hours                      │
│ Half day       │     2x      │ Full day                     │
│ This weekend   │     2x      │ Two weekends (or help)       │
└─────────────────────────────────────────────────────────────┘

Adjusted estimate: _____________

What could go wrong: _________________________________
Buffer added for that: _____________

FINAL ESTIMATE: _____________
```

### Visual Timers

**Recommended Tools:**
- **Time Timer** (physical) - Visual countdown, no math
- **Forest App** - Phone lockout with gamification
- **Toggl Track** - See where time actually goes
- **Pomodoro apps** - 25/5 minute cycles

**Timer Strategies:**
```
FOR STARTING: "I'll work for 10 minutes only"
FOR STOPPING: "Alarm means STOP, no exceptions"
FOR AWARENESS: "Timer shows time PASSING, not just ending"
FOR TRANSITIONS: "5 minute warning before all transitions"
```

## Organization Systems

### The One-Touch Rule
```
ITEM ARRIVES → DECIDE NOW → ONE DESTINATION

Paper:     Read → Action/File/Trash (never "pile")
Email:     Read → Reply/Forward/Archive/Delete (now)
Object:    Use → Return to home (immediately)
Idea:      Capture → Process location (not brain)
```

### The Launch Pad
One spot by the door containing EVERYTHING you need to leave:
```
┌──────────────────────────┐
│      LAUNCH PAD          │
├──────────────────────────┤
│ Keys (hook)              │
│ Wallet                   │
│ Phone charger            │
│ Work bag                 │
│ Sunglasses               │
│ [Daily medication]       │
│ [Anything else you       │
│  forget regularly]       │
└──────────────────────────┘

RULE: Nothing leaves. Nothing else goes here.
```

### The "Home" System
Every object has ONE home. Label if needed.
```
COMMON ADHD TROUBLE ITEMS AND SUGGESTED HOMES:

Keys:           Hook by door (never pocket/purse)
Wallet:         Launch pad bowl
Glasses:        Bedside OR desk (not both)
Medication:     With toothbrush OR coffee maker
Chargers:       ONE per location, don't move
Important docs: ONE folder, fireproof box
```

## Emotional Regulation

### The STOP Technique
```
S - STOP what you're doing
T - TAKE a breath (count to 4)
O - OBSERVE (what am I feeling? what triggered it?)
P - PROCEED mindfully (what's the wise response?)
```

### Rejection Sensitivity Toolkit
```
WHEN YOU FEEL REJECTED:

1. PAUSE - Don't respond for at least 10 minutes
2. NAME IT - "This is RSD, not reality"
3. EVIDENCE CHECK:
   - What did they actually say/do?
   - What am I adding/assuming?
   - Is there another interpretation?
4. GROUND - 5-4-3-2-1 senses technique
5. RESPOND - After emotions settle (hours/days for big things)
```

### Frustration Scripts
Pre-written responses for when executive function fails:

```
WHEN OVERWHELMED:
"I need a few minutes to think about this."

WHEN LATE:
"I apologize for the delay. I'm on my way and will
be there in [specific time]."

WHEN FORGOT SOMETHING:
"I don't have that with me right now. I'll get it to
you by [specific time]."

WHEN CAN'T START:
"I'm having trouble getting started. Can you help me
identify the first step?"

WHEN OVERSTIMULATED:
"I need to step away for a few minutes. I'll be back."
```

## Daily Routines

### Morning Routine Template
```
□ Wake (same time daily, even weekends)
□ NO PHONE for first 30 min
□ Water + medication (if applicable)
□ [Movement: stretch, walk, anything]
□ Hygiene basics
□ Check calendar for day's commitments
□ Identify THE Thing
□ Launch pad check before leaving
```

### Evening Routine Template
```
□ Shutdown ritual at work (5 min)
□ Brain dump anything still in head
□ Tomorrow's THE Thing identified
□ Clothes laid out
□ Launch pad staged
□ Phone charging OUTSIDE bedroom
□ Same bedtime (±30 min)
```

### Weekly Reset (30 min Sunday)
```
□ Calendar review for upcoming week
□ Identify THE Thing for each day
□ Process capture notes/voice memos
□ Doom box: 15 items sorted
□ One home reset (put things back)
□ Meal planning (or decide on backup plan)
```

## Medication Management

### Tracking Template
```
DATE: _______  MEDICATION: _______ DOSE: _______

Morning:
- Took at: _______
- With food? Y/N
- Sleep last night: _____ hours

Tracking (1-10 scale):
- Focus: ___/10
- Energy: ___/10
- Mood: ___/10
- Appetite: ___/10
- Anxiety: ___/10

ONSET: Felt effects at: _______
PEAK: Best effectiveness: _______
OFFSET: Effects faded: _______

Notes/Side effects:
_________________________________

Tomorrow adjustment needed? Y/N
What: _________________________
```

### Medication Reminder Systems
```
OPTION 1: Pair with existing habit
"Medication lives WITH coffee maker"

OPTION 2: Alarm with specific label
"9:00 AM - TAKE MEDS" (not just "reminder")

OPTION 3: Pill organizer + visual check
Weekly fill, daily visual confirmation

OPTION 4: Accountability
Text buddy when taken
```

## Crisis Protocols

### When Everything Is On Fire
```
STOP. You will not solve this while panicking.

1. BREATHE - 4-7-8 breathing x 3
2. DUMP - Write EVERYTHING onto paper (2 min max)
3. CIRCLE - Mark only 1-3 things that truly must happen today
4. SMALLEST - What's the tiniest step toward #1?
5. TIMER - Set for 15 minutes
6. DO - Just the smallest step
7. REASSESS - After timer, what's next?
```

### The "Minimum Viable Day"
When you can't do a full day, do this:
```
□ Take medication (if applicable)
□ Eat something
□ Shower OR change clothes
□ ONE work thing (even partial)
□ Brief outside time (even 5 min)
□ Reasonable bedtime

THAT'S IT. This counts. This is enough.
```
