# ADHD X Bookmark Analysis

**Your bookmarks are a graveyard. This brings them back to life.**

## Quick Start

1. **Install files** to your OpenClaw workspace
2. **Configure X access** (bird CLI or browser cookies)
3. **Set delivery channel** in `bookmark-rules.md`
4. **Test it:** "Analyze my X bookmarks from this week"
5. **Automate it:** Add cron job for daily summaries

## What You Get

- 📚 **Smart categorization** of all your X bookmarks
- 🎯 **Key insight extraction** (no more re-reading to remember why you saved it)
- 📬 **Daily Discord summaries** of what you bookmarked
- 🔍 **Searchable archive** of everything you've saved
- 🧠 **Second brain** that actually works

## Files

- `SKILL.md` — Full documentation and setup guide
- `bookmark-rules.md` — Categorization logic and delivery config
- `example-cron.sh` — Sample automation script
- `bookmark-archive/` — Your searchable bookmark archive (created on first run)

## Example Output

```
📚 X Bookmark Summary — Feb 15, 2026

You saved 18 bookmarks in the last 24 hours. Here's what stood out:

🤖 AI & Tech Tools (7 bookmarks)
• New Claude API pricing ($0.25/M tokens output)
• OpenClaw 0.7.0 release notes
• Thread on RAG vs fine-tuning tradeoffs

💼 Business & Strategy (5 bookmarks)
• How @username built $50K MRR with AI agents
• Pricing psychology thread (15 tactics)
...
```

## Why This Exists

Because you:
- Bookmark 50 tweets a day
- Read maybe 2
- Can never find that one thing you saved
- Feel guilty about the graveyard of unread content

This skill fixes that. Automatically.

---

**Built for ADHD brains who collect everything and process nothing.**
