# Body Doubling Protocols v2.0 🐱⚡

*Part of ADHD-founder.com ecosystem*

---

## Session Types (Free)

### 🔥 Quick Fire (25 min)
- 25 min focused work
- 1 check-in at 15 min (NOT end of session)
- Hard stop at 25

### 🎯 Deep Dive (50 min)
- 50 min focused work  
- 2 check-ins (15 & 35 min)
- 10 min break after

### 🚀 Sprint (90 min)
- 3×25 min pomodoro
- Check-ins every 20-25 min
- Progress review at end

### 💼 Extended (2+ hours)
- Multiple pomodoros
- Check-ins every 20-25 min
- Mandatory breaks between blocks

---

## NEW: First Micro-Step Protocol 🎯

**When starting ANY session:**

1. **Ask the task**: "What are you working on?"
2. **Ask the first step**: "What's the FIRST micro-step?" (must be under 2 minutes)
3. **Shrink it**: "That's good, but what's the SMALLEST possible version of that?"
4. **Commit**: "Do that NOW. I'll wait. Report back when done."
5. **Validate**: "Done? Great. Next micro-step?"

**Why this works:**
- Bypasses the "I don't know where to start" paralysis
- Creates immediate momentum
- Builds commitment through small wins
- ADHD brains need concrete starting points, not abstract goals

---

## NEW: Check-In Schedule (Every 15-25 min)

### NEVER go more than 25 minutes without contact.

**15 min session:**
- Check-in at 10 min

**25 min session:**
- Check-in at 15 min

**50 min session:**
- Check-in at 15 min
- Check-in at 35 min

**90+ min sessions:**
- Check-in every 20-25 min
- "What micro-step are you on?"

### Check-In Questions (Free)

#### Standard Check-In
- "What micro-step did you just complete?"
- "Where are you at RIGHT NOW? (be specific)"
- "What's the next micro-step?"
- **Founder twist:** "Did this move the needle or just feel productive?"

#### Push-Back Mode (NEW)
When responses are vague:
- "That's vague. What SPECIFICALLY did you do?"
- "Is that a reason or an excuse?"
- "What exactly is blocking you? Name it."
- "Are you avoiding this or is it a real blocker?"
- "Tell me the EXACT next action, not the general area."

#### Follow-Up Questions (NEW)
- "You said it was hard - what PART is hard?"
- "You mentioned distractions - which ones?"
- "You feel stuck - what have you actually tried?"
- "This isn't working - what would 'working' look like?"

---

## NEW: Auto Micro-Task Suggestion Protocol 🧠

**When user says they're stuck, automatically offer:**

### The 2-Minute Rule
"What's something you could do in 2 minutes that moves this forward?"

### Entry Point Options
1. **Write ONE** - One sentence, one line, one bullet
2. **Open and stare** - Open the file/app, look for 60 seconds
3. **List the NOTs** - 3 things you DON'T need to do for this task
4. **Do the easy part** - Skip the hard part, do what you know
5. **5-minute promise** - "I'll work on this for 5 min, then I can stop"

### The Pre-Mortem
"What would make this fail? Let's prevent that."

### The Delegation Check
"Do YOU need to do this, or could someone else do 80% of it?"

### The Energy Match
"You have [low/medium/high] energy right now. Which micro-task matches that?"

---

## Dopamine Menu 🧠⚡ (Free)

When you're stuck, try ONE of these (2-5 min):

1. **Physical Reset** - 10 jumping jacks, stretch, walk around
2. **Sensory Swap** - Change environment, open window, different music
3. **Micro-Win** - Complete ONE tiny task (empty inbox, clear desk)
4. **External Input** - Watch 1 min of motivating content, then go
5. **Brain Dump** - Write everything in head to paper for 2 min
6. **Hydrate** - Drink water, splash face
7. **Permission Slip** - "You have 5 min to do nothing. Then we're back."

**Rule: Pick ONE. Do it. Back to work.**

---

## Emergency Reset Protocol 🚨 (Free)

When TOTALLY blocked (can't start, can't focus, want to quit):

1. **Stop** (30 sec) - Close everything, hands off keyboard
2. **Breathe** (30 sec) - 3 deep breaths, no phone
3. **Ask** (1 min) - "What's the ONE thing I'm avoiding?"
4. **Shrink** (1 min) - Make the task 10x smaller (First Micro-Step)
5. **Promise** (30 sec) - "I will do this for 5 minutes only"
6. **Go** - Start the tiny task

**If still blocked after 5 min → End session. No shame.**

---

## Reality Check Mode 🎯 (Free)

Honest questions when you're not making progress:

- "What do you actually want to do right now?"
- "Is this task real or are you punishing yourself?"
- "What would you do if no one was watching?"
- "What's the worst that happens if you stop?"
- "Is this resistance or do you actually need rest?"
- **Founder twist:** "Is this earning or burning?"

---

## NEW: Session History Tracking 📊

Track every session in: `~/.openclaw/skills/adhd-body-doubling/history/`

### Data Captured
- **Session metadata** - ID, timestamp, planned/actual duration
- **Task info** - Category, description, first micro-step
- **Context** - Time of day, starting energy level
- **Outcomes** - Completion rate, ending energy
- **What worked** - Focus techniques that helped
- **What didn't** - Distractions, blockers
- **Dopamine Menu usage** - Which resets were used
- **Check-ins** - How many, completion status

### Pattern Recognition
Over time, identify:
- Best session lengths for YOUR brain
- Optimal times of day
- Task types that flow vs. resist
- Which Dopamine Menu items actually help
- Completion rate by category

### History Query Examples
```
/body-doubling history           # Last 10 sessions
/body-doubling history --week    # This week
/body-doubling history --best    # Highest completion rate
/body-doubling history coding    # Only coding sessions
```

---

## Session Autopsy Template 🔍 (Free)

After every session, answer:

1. **What worked?** (What helped you focus?)
2. **What didn't?** (What killed your focus?)
3. **One thing for next time?** (Just one)
4. **What did you actually accomplish?** (List it - even small wins)

**Example Output:**
```
SESSION AUTOPSY 📊
Work done: 
- Wrote 500 words of landing page
- Sent 3 outreach emails
- Fixed pricing bug

What helped: Music, no phone, micro-steps
What killed: Email notifications
Next time: Put phone in other room
Energy pattern: Started 7/10, ended 5/10
```

---

## The Anti-Shame Pledge

Remember:

- ✦ Not every session is perfect
- ✦ Missing a session ≠ being a failure
- ✦ Struggles are normal, not weakness
- ✦ Asking for help is strength
- ✦ You are not your productivity

**Your worth is not measured by completed tasks.**

---

---

*Part of [ADHD-founder.com](https://adhd-founder.com) - German Engineering for the ADHD Brain*
