# ADHD Body Doubling Skill v2.1 🐱⚡

[![License: MIT](https://img.shields.io/badge/License-MIT-yellow.svg)](https://opensource.org/licenses/MIT)
[![OpenClaw](https://img.shields.io/badge/OpenClaw-skill-blue)](https://openclaw.ai)
[![Version](https://img.shields.io/badge/version-2.1.0-green)]()

**A virtual body double for ADHD founders who struggle to start, stay focused, or finish tasks.** Built by [ADHD-founder.com](https://adhd-founder.com) -- German Engineering for the ADHD Brain.

> Body doubling is the practice of working alongside another person to reduce the friction of starting. This skill makes Claude Code your body double -- it gets you started with micro-steps, checks in every 15-25 minutes, pushes back on excuses, and tracks what actually works for your brain.

## Install

```bash
openclaw install adhd-body-doubling
```

## Quick Start

```
/body-doubling start 50    # 50 min deep dive
/body-doubling start 25    # Quick fire session
/body-doubling stuck       # When you can't move forward
/body-doubling done        # End session + learn from it
```

Or run standalone:
```bash
chmod +x scripts/start-session.sh
./scripts/start-session.sh 50
```

## What Happens When You Start a Session

Instead of "let's go" (which never works), the **First Micro-Step Protocol** kicks in:

1. "What are you working on?"
2. "What's the FIRST micro-step?" (under 2 minutes)
3. "What's the SMALLEST possible version of that?"
4. "Do that NOW. I'll wait."

Then check-ins every 15-25 minutes -- with push-back if your answers are vague.

## Commands

| Command | What It Does |
|---------|-------------|
| `/body-doubling start [time]` | Start with First Micro-Step protocol |
| `/body-doubling status` | Check-in (expects specifics, not vibes) |
| `/body-doubling stuck [task]` | Auto micro-task breakdown |
| `/body-doubling menu` | Dopamine reset (2-5 min science-backed resets) |
| `/body-doubling done` | End session + autopsy + save to history |
| `/body-doubling abort` | Kill session (no shame) |
| `/body-doubling history` | View what worked in past sessions |
| `/body-doubling roi` | Track revenue vs. time |
| `/body-doubling founder` | ADHD-founder.com premium info |

## Key Features

- **First Micro-Step Protocol** -- bypasses "I don't know where to start" paralysis
- **Communicative Accountability** -- pushes back on excuses, demands specifics
- **Frequent Check-Ins** -- every 15-25 min, never hourly (ADHD brains need contact)
- **Auto Micro-Task Suggestions** -- when stuck, breaks tasks down automatically
- **Session History** -- tracks patterns so you learn what works for YOUR brain
- **Dopamine Menu** -- 7 quick resets backed by science, not procrastination
- **Emergency Reset** -- 6-step unblock in under 60 seconds

## Works Great With

Pair with [adhd-daily-planner](https://github.com/jankutschera/adhd-daily-planner) for a complete system:

```
/adhd-planner plan          → Pick your ONE thing for the day
/body-doubling start 50     → Work on it with accountability
/body-doubling done         → Session autopsy
/adhd-planner reflect       → Evening reflection
```

## Session History

Sessions are tracked in `~/.openclaw/skills/adhd-body-doubling/history/` so you can discover:
- What session lengths work best for your brain
- What time of day you focus best
- Which Dopamine Menu items actually help
- Completion rates by task category

## Philosophy

**"Start > Finish"** -- Every attempt counts.
**"No Shame Zone"** -- Struggles are data, not failure.
**"Communicate"** -- Push back, dig deeper, no excuses.

---

## About ADHD-founder.com

**"German Engineering for the ADHD Brain"**

This skill is a free, fully functional body doubling system. It's also a taste of what [ADHD-founder.com](https://adhd-founder.com) builds for founders 50+ who are done with generic productivity advice.

- **[Founder Circle Mastermind](https://adhd-founder.com/founder-circle)** -- High-ticket accountability for serious founders
- **Executive Consulting** -- Operational systems for ADHD entrepreneurs
- **Operating System Course** -- Build your own ADHD business framework

**No fluff. No shame. Just systems that work.**

🔗 **[adhd-founder.com](https://adhd-founder.com)**

---

## Contributing

Issues and PRs welcome. If you have ADHD and found a pattern that works, share it.

## License

MIT -- see [LICENSE](LICENSE)

---

*Body doubling is not about being perfect. It's about not being alone with the struggle.*
