# Addis Assistant API Specifications

## Speech-to-Text (STT) API

**Endpoint:** `api.addisassistant.com/api/v2/stt`
**Method:** `POST`

```bash
curl --location 'api.addisassistant.com/api/v2/stt' \
 --header 'x-api-key: Your-api-key' \
 --form 'audio=@"/path/to/file.wav"' \
 --form 'request_data="{ \"language_code\": \"am\" }"'
```

**Parameters:**
- `x-api-key`: Your API key for authentication.
- `audio`: Path to the audio file (e.g., `"@/path/to/file.wav"`). Ensure the path is correctly escaped.
- `request_data`: JSON string containing `language_code` (e.g., `"am"` for Amharic).

## Translation API

**Endpoint:** `api.addisassistant.com/api/v1/translate`
**Method:** `POST`

```bash
curl --location 'api.addisassistant.com/api/v1/translate' \
 --header 'Content-Type: application/json' \
 --header 'x-api-key: Your-api-key' \
 --data '{"text": "ገበሬው ማሳውን ዘወትር ይጎበኛል", "source_language": "am", "target_language": "en"}'
```

**Parameters:**
- `x-api-key`: Your API key for authentication.
- `text`: The text string to be translated.
- `source_language`: The language code of the input text (e.g., `"am"`).
- `target_language`: The language code for the desired translation (e.g., `"en"`).
- `Content-Type`: Must be `application/json`.
