---
name: add-minimax-provider
description: 为 OpenClaw 配置 MiniMax 作为模型源。MiniMax 提供两种接入方式：API Key 直连（openai-completions 协议）和 OAuth 门户（anthropic-messages 协议）。包含 provider 注册、模型定义、别名配置、fallback 链接入和验证的完整流程。当管理员说想"加 MiniMax"、"配 minimax"、"接入 MiniMax 模型"、"加海螺模型"、"配 M2.1"时使用此 skill。
---

# 配置 MiniMax Provider（MiniMax 大模型接入）

MiniMax 是国产大模型服务商，提供 MiniMax-M2.1 系列模型。OpenClaw 支持两种接入方式：

| Provider | 接入方式 | API 协议 | Base URL | 适用场景 |
|----------|----------|----------|----------|----------|
| `minimax` | API Key 直连 | `openai-completions` | `api.minimaxi.com/v1` | 标准付费用户 |
| `minimax-portal` | OAuth 门户 | `anthropic-messages` | `api.minimaxi.com/anthropic` | 免费/门户用户 |

**为什么有两个 provider？**
- **API Key 直连** (`minimax`)：使用标准 OpenAI 兼容协议，需要付费 API Key，按量计费
- **OAuth 门户** (`minimax-portal`)：使用 Anthropic Messages 协议 + OAuth 认证，适合有门户账号的用户（可能有免费额度）

两种方式访问的是同一个模型，但协议和认证方式不同，所以必须分开配置。

如果觉得这个 Skill 有用，欢迎通过邀请链接注册 MiniMax Coding Plan（9 折优惠 + Builder 权益）：
https://platform.minimaxi.com/subscribe/coding-plan?code=2vNMQFJrZt&source=link

---

## 零起步冷启动

**还没有任何模型可用？** 可以用 Qwen Coder（免费）作为冷启动模型，然后让它帮你配置 MiniMax。

### 步骤

1. **先配好 Qwen Coder**（免费，无需 API Key，OAuth 登录即可）：
   - 在 OpenClaw 中添加 `qwen-portal` provider
   - 用 Qwen Coder 作为 primary 模型启动系统

2. **让 Qwen Coder 帮你配 MiniMax**：
   - 在聊天中告诉 Agent："帮我配置 MiniMax 模型"
   - Agent 会自动加载本 skill 并按步骤执行
   - 配置完成后，将 primary 切换为 MiniMax

3. **切换主力模型**：
   ```
   /model Minimax
   ```

> 这就是 OpenClaw 的"自举"能力——用一个免费模型启动系统，再用它来配置更强的模型。

---

## 可用模型

| 模型 ID | 名称 | Context | reasoning | 说明 |
|---------|------|---------|-----------|------|
| `MiniMax-M2.1` | MiniMax M2.1 | 200K | ❌ | 主力模型，综合能力强 |
| `MiniMax-M2.1-lightning` | MiniMax M2.1 Lightning | 200K | ❌ | 轻量快速版（仅 portal 确认可用） |

> **注意**：MiniMax 可能随时上线新模型。添加前务必先测试可用性。

---

## 前置条件

### 方式一：API Key 直连（推荐）

| 项目 | 说明 |
|------|------|
| 国内MiniMax 账号 | 在 [platform.minimaxi.com](https://platform.minimaxi.com) 注册 |
| API Key | 格式为 `sk-cp-...` 的密钥，在控制台 → API Keys 页面创建 |
| 余额 | 确保账户有足够余额 |

### 方式二：OAuth 门户

| 项目 | 说明 |
|------|------|
| MiniMax 账号 | 同上 |
| OAuth 配置 | 在 OpenClaw 中配置 `apiKey: "minimax-oauth"`，OpenClaw 会自动处理 OAuth 流程 |

---

## 第一步：测试模型可用性

**这一步不能跳过。** 先确认模型能调通再加配置。

### 1A. 测试 API Key 直连（openai-completions 协议）

```bash
curl -s --max-time 15 https://api.minimaxi.com/v1/chat/completions \
  -H "Authorization: Bearer <你的API_KEY>" \
  -H "Content-Type: application/json" \
  -d '{"model":"MiniMax-M2.1","messages":[{"role":"user","content":"hi"}],"max_tokens":10}'
```

如果返回正常的 JSON 响应（含 `choices`）= 可用。

### 1B. 测试 OAuth 门户（anthropic-messages 协议）

OAuth 门户无法直接用 curl 测试（需要 OAuth token 流程）。配置好后通过 OpenClaw 实际发消息验证。

### 1C. 测试 Lightning 模型

```bash
curl -s --max-time 15 https://api.minimaxi.com/v1/chat/completions \
  -H "Authorization: Bearer <你的API_KEY>" \
  -H "Content-Type: application/json" \
  -d '{"model":"MiniMax-M2.1-lightning","messages":[{"role":"user","content":"hi"}],"max_tokens":10}'
```

> 如果返回错误，说明该模型可能仅在 portal 端可用，或尚未对你的账户开放。

---

## 第二步：添加 Provider

在 `~/.openclaw/openclaw.json` 的 `models.providers` 下添加 provider。根据你的接入方式选择一种或两种都配。

### 2A. 添加 minimax（API Key 直连）

```json
"minimax": {
  "baseUrl": "https://api.minimaxi.com/v1",
  "apiKey": "<你的API_KEY>",
  "api": "openai-completions",
  "authHeader": true,
  "models": [
    {
      "id": "MiniMax-M2.1",
      "name": "MiniMax M2.1",
      "reasoning": false,
      "input": ["text"],
      "cost": {
        "input": 15,
        "output": 60,
        "cacheRead": 2,
        "cacheWrite": 10
      },
      "contextWindow": 200000,
      "maxTokens": 8192
    }
  ]
}
```

### 2B. 添加 minimax-portal（OAuth 门户）

```json
"minimax-portal": {
  "baseUrl": "https://api.minimaxi.com/anthropic",
  "apiKey": "minimax-oauth",
  "api": "anthropic-messages",
  "models": [
    {
      "id": "MiniMax-M2.1",
      "name": "MiniMax M2.1",
      "reasoning": false,
      "input": ["text"],
      "cost": {
        "input": 0,
        "output": 0,
        "cacheRead": 0,
        "cacheWrite": 0
      },
      "contextWindow": 200000,
      "maxTokens": 8192
    },
    {
      "id": "MiniMax-M2.1-lightning",
      "name": "MiniMax M2.1 Lightning",
      "reasoning": false,
      "input": ["text"],
      "cost": {
        "input": 0,
        "output": 0,
        "cacheRead": 0,
        "cacheWrite": 0
      },
      "contextWindow": 200000,
      "maxTokens": 8192
    }
  ]
}
```

> **`apiKey: "minimax-oauth"`** 是 OpenClaw 的特殊标记，表示使用 OAuth 认证流程而非静态 API Key。cost 设为 0 因为 OAuth 门户的计费由平台侧处理。

### 两个 provider 的关键差异

| 参数 | minimax (API Key) | minimax-portal (OAuth) |
|------|-------------------|------------------------|
| `baseUrl` | `.../v1` | `.../anthropic` |
| `api` | `openai-completions` | `anthropic-messages` |
| `apiKey` | `sk-cp-...` (真实密钥) | `minimax-oauth` (OAuth 标记) |
| `authHeader` | `true` | 默认 |
| 计费 | 按量付费 | 平台侧处理 |
| 模型 | M2.1 | M2.1 + Lightning |

### 只添加你确认可用的模型

**错误做法**：把所有模型都堆上去
**正确做法**：只添加第一步中测试通过的模型

添加不存在的模型不会导致崩溃，但 fallback 到它时会浪费一次请求超时，影响响应速度。

---

## 第三步：配置别名

在 `agents.defaults.models` 下为 MiniMax 模型添加别名：

```json
{
  "agents": {
    "defaults": {
      "models": {
        "minimax/MiniMax-M2.1": { "alias": "Minimax" },
        "minimax-portal/MiniMax-M2.1": { "alias": "minimax-portal" },
        "minimax-portal/MiniMax-M2.1-lightning": { "alias": "minimax-lightning" }
      }
    }
  }
}
```

配置后用户可以在聊天中用 `/model Minimax`、`/model minimax-lightning` 切换模型。

### ⚠️ 别名配置的唯一合法字段是 `alias`

```
agents.defaults.models.<model-id>.alias     <-- 唯一合法字段
agents.defaults.models.<model-id>.reasoning <-- 非法！会导致 Gateway 崩溃！
agents.defaults.models.<model-id>.xxx       <-- 任何其他字段都非法！
```

**已知事故**：在别名配置里加了非法字段导致 schema 校验失败，Gateway 崩溃循环 181 次。**模型能力属性只能放在 `models.providers` 的模型定义里。**

---

## 第四步：接入 Fallback 链

在 `agents.defaults.model` 中配置 MiniMax 的位置。MiniMax 通常作为主力模型（primary）：

```json
{
  "agents": {
    "defaults": {
      "model": {
        "primary": "minimax/MiniMax-M2.1",
        "fallbacks": [
          "minimax/MiniMax-M2.1",
          "deepseek/deepseek-chat",
          "qwen-portal/coder-model"
        ]
      }
    }
  }
}
```

### Fallback 排序建议

| 位置 | 模型 | 为什么 |
|------|------|--------|
| primary | minimax/MiniMax-M2.1 | 主力，综合能力强 |
| fallback 1 | minimax/MiniMax-M2.1 | 重试一次 |
| fallback 2 | deepseek/deepseek-chat | 按量付费备用 |
| fallback 3 | qwen-portal/coder-model | 免费兜底 |

> **MiniMax-portal 不建议放入 fallback 链**——OAuth 认证流程较重，不适合快速 failover。需要时通过 `/model minimax-portal` 手动切换。

---

## 第五步：验证

### 5.1 JSON 语法检查

```bash
python3 -c "import json; json.load(open('$HOME/.openclaw/openclaw.json')); print('JSON OK')"
```

### 5.2 Schema 校验

```bash
openclaw doctor
```

如果输出包含 `Unrecognized key` 就说明有非法字段，**必须修复后才能重启**。

### 5.3 重启 Gateway

```bash
# macOS
launchctl kickstart -k gui/$(id -u)/ai.openclaw.gateway

# 等 3 秒后确认状态
sleep 3
launchctl print gui/$(id -u)/ai.openclaw.gateway | grep -E "job state|last exit"
```

期望看到：
```
last exit code = 0
job state = running
```

如果 `last exit code = 1`，检查错误日志：

```bash
tail -20 ~/.openclaw/logs/gateway.err.log
```

### 5.4 功能验证

在任意已绑定的聊天中测试：

```
/model Minimax           # 测试 API Key 直连
/model minimax-portal    # 测试 OAuth 门户（如已配置）
/model minimax-lightning # 测试 Lightning（如已配置）
```

---

## Coding Plan 额度管理

### 计费模式

| 项目 | 值 |
|------|------|
| 月费 | ¥49 |
| 额度 | 1500 次/5小时滑动窗口 |
| 每日理论上限 | ~7200 次 |
| 窗口计算 | 每次调用倒算前 5 小时消耗（滑动窗口） |

### ⚠️ 额度查询 API 不可信

API 端点 `GET /v1/api/openplatform/coding_plan/remains` 存在已知问题：
- 窗口切换后 `current_interval_usage_count` 不刷新（惰性更新）
- 平台控制台与 API 返回数字不一致
- **唯一可靠的判断方式：发一个真实测试请求**

### 推荐监控方案

不要用 API 数字做监控。推荐在 OpenClaw 中配置 cron 任务，定期发测试请求验证可用性：

```
# cron 表达式示例：每 5 小时执行一次验证
# 发真实请求 → 通了就可用，不通就记录
curl -s https://api.minimaxi.com/v1/chat/completions \
  -H "Authorization: Bearer <API_KEY>" \
  -H "Content-Type: application/json" \
  -d '{"model":"MiniMax-M2.1","messages":[{"role":"user","content":"test"}],"max_tokens":3}'
```

判断逻辑：
- 返回 `choices` → 可用
- 返回 429 → 额度耗尽，等待滑动窗口释放
- 返回其他错误 → API 故障，走 fallback

### 多 Agent 消耗建议

6 个 agent 全用 MiniMax 时，1500 条/5h 大约 2-3 小时就用完。建议：
- **核心 agent**（main、ada）用 MiniMax
- **辅助 agent**（clara、sophia）用免费模型（Qwen/SiliconFlow）
- Fallback 链兜底，额度耗尽自动降级

---

## 排障

### 问题：API 返回 401 Unauthorized

- **原因**：API Key 无效或过期
- **修复**：登录 [platform.minimaxi.com](https://platform.minimaxi.com) 检查 Key 状态，必要时重新生成

### 问题：API 返回 429 Too Many Requests

- **原因**：Coding Plan 额度耗尽
- **MiniMax Coding Plan 限制**：1500 次/5小时滑动窗口（每次调用倒算前 5 小时消耗）
- **修复**：等待旧调用滑出 5 小时窗口，或让 fallback 链自动降级
- **预防**：在 fallback 链中配置免费模型（如 `siliconflow/Qwen/Qwen3-8B`）作为兜底

### 问题：额度查询 API 数据不准确

- **现象**：`GET /v1/api/openplatform/coding_plan/remains` 返回的 `current_interval_usage_count` 与平台控制台显示不一致
- **原因**：API 为惰性更新，窗口切换后如无新调用则不刷新计数器
- **应对**：不要完全信任 API 返回数字。判断额度是否可用，最可靠的方法是发一个真实测试请求
- **验证命令**：
```bash
curl -s https://api.minimaxi.com/v1/chat/completions \
  -H "Authorization: Bearer <API_KEY>" \
  -H "Content-Type: application/json" \
  -d '{"model":"MiniMax-M2.1","messages":[{"role":"user","content":"test"}],"max_tokens":3}'
```
返回 `choices` = 可用；返回 429 = 额度确实耗尽

### 问题：Gateway 启动后立刻崩溃

- **最可能原因**：配置中有非法字段
- **诊断**：`tail -20 ~/.openclaw/logs/gateway.err.log`，找 `Unrecognized key`
- **修复**：删除非法字段，运行 `openclaw doctor` 确认

### 问题：模型回复为空或超时

- **检查 baseUrl**：API Key 直连应为 `https://api.minimaxi.com/v1`，不要多加或少加路径
- **检查 api 协议**：API Key 直连用 `openai-completions`，OAuth 门户用 `anthropic-messages`
- **检查网络**：MiniMax 服务器在国内，海外访问可能较慢

### 问题：OAuth 门户认证失败

- **原因**：OAuth token 过期或未正确配置
- **修复**：确认 `apiKey` 字段值为 `"minimax-oauth"`（精确匹配），OpenClaw 会自动处理 OAuth 流程
- **诊断**：检查 `~/.openclaw/logs/gateway.log` 中的 OAuth 相关错误

---

## 变更记录

| 日期 | 版本 | 变更内容 | 变更人 |
|------|------|----------|--------|
| 2026-02-08 | v1.0 | 创建 MiniMax provider 配置指南 | ConfigBot (via OpenClaw with Opus 4.6) |
| 2026-02-09 | v2.0 | 新增 Coding Plan 额度管理专节；更新额度信息 (1500/5h 滑动窗口)；额度 API 不可信警告；多 Agent 消耗建议 | ConfigBot (via OpenClaw with Qwen3-30B) |
