# Ad Creative Analysis Framework

Reference material for the `ad-creative-analysis` skill. Use this when scoring creatives, identifying patterns, and writing recommendations.

---

## Scoring Rubrics

### Image Scores

#### Attention Grab (1-10)

How fast and powerfully does the creative stop a scroll?

| Score | Criteria |
|-------|----------|
| 9-10  | Immediately arrests attention — bold contrast, unexpected visual, or strong emotional image. Would stop 80%+ of scrollers. |
| 7-8   | Visually distinct, stands out in feed. Most scrollers would pause. |
| 5-6   | Noticeable but not striking. Blends with typical feed content. |
| 3-4   | Low contrast or generic imagery. Easy to scroll past. |
| 1-2   | Invisible in feed. No visual differentiation from organic content. |

Key signals that raise score: high contrast between subject and background, human faces with clear emotion, unexpected or counterintuitive visuals, strong bright color against neutral backgrounds, movement implied in static image.

Key signals that lower score: stock photo feel, cluttered composition, low contrast, text-heavy without visual anchor, identical to a hundred other ads.

#### Message Clarity (1-10)

Can someone understand the core message in under 3 seconds without needing context?

| Score | Criteria |
|-------|----------|
| 9-10  | One dominant message, instantly understood. No ambiguity about what is being offered or why it matters. |
| 7-8   | Clear message but requires reading the body copy to fully grasp the offer. |
| 5-6   | Message is present but requires effort. Too much text or competing ideas. |
| 3-4   | Multiple competing messages or vague benefit claims. |
| 1-2   | Unclear what is being advertised or who it is for. |

Key signals that raise score: single benefit stated prominently, direct language (no jargon), visual and text reinforce the same message, benefit over feature framing.

#### CTA Strength (1-10)

How compelling and friction-reducing is the call-to-action?

| Score | Criteria |
|-------|----------|
| 9-10  | Specific, action-oriented verb. Includes value or urgency signal. Easy to act on immediately. |
| 7-8   | Clear action verb, benefit implied. Minor friction (e.g., missing urgency). |
| 5-6   | Generic CTA ("Learn More", "Click Here"). Action is clear but motivation is missing. |
| 3-4   | CTA is weak, buried, or hard to find. |
| 1-2   | No CTA or CTA is purely passive. |

Strong CTA examples: "Get 50% off today", "Start your free trial", "Claim your spot — only 3 left", "Download free now".
Weak CTA examples: "Learn more", "Click here", "Visit our website".

---

### Video Scale Score (1-10)

The scale score measures how likely a video ad is to perform profitably at significant ad spend.

| Score | Criteria |
|-------|----------|
| 9-10  | Hook stops the scroll in under 2 seconds. Script follows a clear persuasion arc. CTA is strong and timed correctly. Production quality matches platform norms. Would test immediately at scale. |
| 7-8   | Hook is effective, script is coherent, CTA is clear. One or two elements could be stronger but fundamentals are solid. Good candidate for testing. |
| 5-6   | Core idea is present but execution is average. Hook works for some audiences, script loses focus mid-way, or CTA is too soft. Needs a single focused revision before testing. |
| 3-4   | Identifiable hook or message but execution issues throughout. Weak opening, scattered script, or CTA absent/late. Requires significant rework. |
| 1-2   | No clear hook, no coherent message, no CTA. Unlikely to generate results at any spend level. |

Factors that raise scale score:
- Hook creates a pattern interrupt (unexpected, funny, shocking, emotionally resonant)
- Viewer's core desire or pain is named explicitly within 5 seconds
- Social proof is specific (numbers, names, before/after)
- CTA includes a reason to act now
- Video length matches platform norms (TikTok/Reels: 15-60s, Facebook/YouTube: 30-90s)

Factors that lower scale score:
- Slow intro, brand logo before any hook
- Vague benefit claims without specifics
- No demonstration or proof element
- CTA only at the very end with no buildup
- Talking head with no B-roll or text overlays

---

## Ad Psychology Patterns

### The 9 Core Emotion Appeals

Use these to classify and analyze the primary emotional driver in any creative.

#### 1. Fear
Activates loss aversion and threat response. Most powerful motivator when the threat feels real and immediate.
- Examples: "Are you making this mistake with your money?", "Your competitors are already using this"
- Works best for: insurance, health, security, financial products, B2B tools
- Risk: Too heavy-handed fear causes disengagement. Must pair with clear solution.

#### 2. Aspiration
Sells the future identity the viewer wants to inhabit. More effective than product features alone.
- Examples: "What if you could work from anywhere?", "Imagine waking up debt-free"
- Works best for: lifestyle brands, fitness, travel, education, financial freedom
- Key signal: "You" language + future tense + visual of desired life

#### 3. Social Proof
Reduces risk by showing others have succeeded. Peer trust outperforms brand claims.
- Examples: "Join 2 million users", "5-star reviews from 18,000 customers", testimonial videos
- Works best for: apps, e-commerce, SaaS, health products
- Specificity multiplies impact: "2,347 women have used this to lose their first 10kg"

#### 4. Urgency
Creates time pressure that overrides procrastination. Real scarcity is more believable than artificial.
- Examples: "Offer ends midnight tonight", "Only 12 spots remaining", "Flash sale — 4 hours left"
- Works best for: e-commerce, event registration, limited offers
- Risk: Overuse trains audiences to ignore urgency signals.

#### 5. Curiosity
Opens a loop the viewer must close. Most effective at earning clicks and views.
- Examples: "The one ingredient dermatologists don't want you to know about", "We tried this for 30 days — here's what happened"
- Works best for: content marketing, top-of-funnel awareness, editorial-style ads
- Key signal: Information gap between what is known and what is revealed

#### 6. Humor
Disarms resistance and makes the brand memorable. Hardest to execute consistently.
- Examples: absurd product demos, self-aware brand jokes, relatable everyday fail moments
- Works best for: consumer apps, food and beverage, younger demographics
- Risk: Humor that lands culturally/locally may not scale globally.

#### 7. Trust
Positions the brand as credible, safe, and expert. Counters skepticism.
- Examples: founder story, clinical studies, media logos ("as seen in Forbes"), certifications
- Works best for: health, finance, legal, high-ticket products, first-time buyers
- Key signal: Third-party validation over self-claims

#### 8. Belonging
Taps into identity and group membership. "People like me use this."
- Examples: "Made for founders who are tired of corporate BS", community-focused messaging
- Works best for: niche products, lifestyle brands, communities, membership platforms
- Key signal: Us vs. them framing, insider language

#### 9. Exclusivity
Creates status through access limitation. Elevates perceived value.
- Examples: "Invite only", "Not for everyone", "Apply to join", waitlist mechanics
- Works best for: premium products, high-ticket offers, membership programs
- Key signal: Language that implies not everyone qualifies

---

## Hook Formula Templates

Hooks are the first 3 seconds of video or the first headline/visual of an image. They determine whether the ad is seen at all.

### 1. Problem-Agitate-Solve (PAS)
Structure: Name the problem → twist the knife → reveal the solution.
- "Tired of wasting hours on invoicing? Most freelancers lose 6 hours per week on admin. We built [Product] to get that back."
- Best for: Products solving a painful, known problem.

### 2. Before-After (BA)
Structure: Show or describe the undesirable before state → reveal the after state.
- "In January I had $0 in savings. By June I had $8,000. Here's exactly what I changed."
- Best for: Transformations, results-driven products, health and fitness, finance.

### 3. Question-Reveal (QR)
Structure: Ask a question that the viewer immediately answers mentally → reveal surprising answer.
- "What's the one thing 90% of gym-goers get wrong?" (viewer thinks of their own habit) → "It's not diet or training — it's sleep."
- Best for: Top-of-funnel awareness, content-style ads, curiosity-driven categories.

### 4. Bold Claim (BC)
Structure: Open with an audacious, specific, and credible claim.
- "This 12-minute routine replaced my $400/month gym membership."
- "We generated $100k in revenue with a $500 ad budget. Here's how."
- Best for: Performance products, business tools, anything with verifiable results.

### 5. Curiosity Gap (CG)
Structure: Reveal partial information, withhold the payoff until they engage.
- "I stopped using sunscreen after learning this." (pause) "Let me explain..."
- "The three words that tripled our conversion rate."
- Best for: Scroll-stoppers, click-bait done ethically, educational content.

### 6. Demonstration (DEMO)
Structure: Show the product in use immediately, results visible in seconds.
- Silent unboxing, before-after split screen, product speed demo
- "Watch what happens when you apply this to a 10-year-old stain."
- Best for: Physical products, cleaning, beauty, kitchen gadgets, apps with clear UI.

### 7. Social Proof Opening (SP)
Structure: Lead with a testimonial, review, or result before any branding.
- "I lost 22kg without stepping into a gym" (user testimonial, no logo)
- "Over 50,000 people have switched from [Competitor] to us this year"
- Best for: Trust-building, competitive categories, products with strong reviews.

### 8. Pattern Interrupt (PI)
Structure: Open with something visually or audibly unexpected — breaks the scroll autopilot.
- Unusual sound, unexpected text card, extreme close-up, reverse footage
- "WAIT — before you scroll past..." (text card, hard cut)
- Best for: Saturated categories, retargeting audiences, viral/entertainment formats.

---

## Example Analysis Output

Full output structure for a batch of 3 creatives.

```json
[
  {
    "filename": "summer_sale_banner.jpg",
    "type": "image",
    "ad_format": "single_image",
    "aspect_ratio": "4:5",
    "dimensions": "1080x1350",
    "ad_objective": "conversion",
    "platform_fit": ["Instagram Feed", "Facebook Feed"],
    "scores": {
      "attention_grab": 7,
      "message_clarity": 8,
      "cta_strength": 6
    },
    "primary_message": "Get 40% off all activewear this weekend only",
    "emotion_appeal": "urgency",
    "target_audience": "Women 20-35 interested in fitness and athleisure",
    "hook_text": "40% OFF — This Weekend Only"
  },
  {
    "filename": "testimonial_hero.jpg",
    "type": "image",
    "ad_format": "single_image",
    "aspect_ratio": "1:1",
    "dimensions": "1080x1080",
    "ad_objective": "consideration",
    "platform_fit": ["Instagram Feed", "Facebook Feed", "LinkedIn"],
    "scores": {
      "attention_grab": 8,
      "message_clarity": 9,
      "cta_strength": 7
    },
    "primary_message": "Real customer lost 18kg using this programme",
    "emotion_appeal": "social_proof",
    "target_audience": "Adults 30-50 who have struggled to lose weight long-term",
    "hook_text": "I lost 18kg in 4 months — and I never felt hungry"
  },
  {
    "filename": "product_demo_reel.mp4",
    "type": "video",
    "ad_format": "reel",
    "aspect_ratio": "9:16",
    "dimensions": "1080x1920",
    "ad_objective": "conversion",
    "platform_fit": ["Instagram Reels", "TikTok", "Facebook Reels"],
    "scale_score": 8,
    "hook_text": "I was doing this wrong for 3 years",
    "hook_type": "curiosity_gap",
    "main_message": "This blender setting cuts prep time from 15 minutes to 90 seconds",
    "emotion_appeal": "curiosity",
    "cta_text": "Get yours — 30% off this week only",
    "cta_timing": "end"
  },
  {
    "summary": {
      "total_analyzed": { "images": 2, "videos": 1 },
      "top_performers": ["testimonial_hero.jpg", "product_demo_reel.mp4", "summer_sale_banner.jpg"],
      "dominant_emotion": "social_proof",
      "common_hooks": [
        "Discount/urgency signal in headline",
        "Curiosity gap with personal experience framing"
      ],
      "cta_patterns": [
        "Percentage discount + time limit",
        "Personal result claim + implicit CTA"
      ],
      "dominant_objective": "conversion",
      "format_breakdown": { "single_image": 2, "reel": 1 },
      "recommendations": [
        "The testimonial image scores highest — produce 3-5 more customer result images with the same format",
        "The sale banner CTA ('Shop Now') is generic — test 'Claim 40% Off' or 'Shop Before Sunday' for specificity",
        "No carousel format tested — try a carousel showing multiple product uses or a step-by-step transformation",
        "All three ads target conversion — add one awareness-stage ad (curiosity hook, no price mention) to build retargeting pools",
        "The video hook is strong but the product reveal takes 8 seconds — move the demo earlier to reduce drop-off"
      ]
    }
  }
]
```
