# Section-Specific Strategies

## English (75 questions, 45 min)

**What it tests:** Grammar, punctuation, sentence structure, rhetoric

**High-ROI topics:**
- Comma rules (most common errors)
- Subject-verb agreement
- Pronoun agreement and case
- Parallel structure
- Redundancy (shorter is usually better)

**Pacing trap:** Don't re-read entire passage — read surrounding sentences only

**When to guess:** If question asks about "best placement" or "which choice," wrong answers are usually obviously wrong

## Math (60 questions, 60 min)

**What it tests:** Pre-algebra through trigonometry

**Question distribution:**
- Pre-algebra/Elementary algebra: 20-25%
- Intermediate algebra/Coordinate geometry: 25-30%
- Plane geometry: 20-25%
- Trigonometry: 10%

**High-ROI topics:**
- Word problems (setup, not calculation)
- Coordinate geometry (slopes, midpoints)
- Triangle properties (30-60-90, 45-45-90)
- Basic trig (SOHCAHTOA, unit circle)

**Pacing trap:** Hard questions at the end are worth the same as easy ones — don't burn time

**Calculator strategy:** Use for arithmetic, not for understanding

## Reading (40 questions, 35 min)

**What it tests:** Comprehension across 4 passages

**Passage order:**
1. Prose Fiction/Literary Narrative
2. Social Science
3. Humanities
4. Natural Science

**Strategy choice:**
- Read passage first → answer questions (if fast reader)
- Skim passage → questions → reread for answers (if slow reader)
- Questions first → hunt for answers (if very slow reader)

**Pacing trap:** Spending too long on one passage — budget 8-9 min max per passage

**Evidence questions:** Answer is ALWAYS in the text — if inferring too much, wrong

## Science (40 questions, 35 min)

**What it tests:** Data interpretation, NOT science knowledge

**Passage types:**
- Data Representation (graphs, tables): easiest
- Research Summaries (experiments): medium
- Conflicting Viewpoints (two scientists disagree): hardest

**Critical insight:** You don't need to understand the science — just read the graphs and tables

**Pacing trap:** Reading background info too carefully — skip to data, answer questions

**Conflicting Viewpoints:** Identify what EACH scientist claims before answering

## Writing (Optional, 40 min)

**What it tests:** Argument analysis and writing

**Structure:**
- Intro with thesis
- 3 body paragraphs (analyze perspectives, present your own)
- Conclusion

**Scoring:** 4 domains (Ideas, Development, Organization, Language), each 2-12

**Only prep if:** Target colleges require or recommend Writing score
