# Acoustic Guitar Progress Tracking

Reference for file structure and logging format.

## Workspace Structure

```
~/acoustic-guitar/
├── repertoire.md      # Songs learned and in progress
├── sessions/
│   └── YYYY-MM.md     # Monthly practice logs
├── technique.md       # Patterns, strumming, fingerpicking
└── goals.md           # Short and long-term goals
```

## Repertoire Format

```markdown
# repertoire.md

## Currently Learning
- Blackbird — Beatles, started 2024-01-15
  - Struggle: thumb independence in verse
  - Next: add vocals while playing

- Dust in the Wind — Kansas, started 2024-02-01
  - Working on: consistent picking pattern

## Completed
- Wonderwall — Oasis (strumming foundation)
- House of the Rising Sun — fingerpicking intro
- Landslide — Fleetwood Mac (Travis picking)

## Want to Learn
- Classical Gas — Mason Williams (goal piece)
- Stop This Train — John Mayer (thumb slap)
```

## Technique Tracking

```markdown
# technique.md

## Fingerpicking Patterns
| Pattern | Status | Notes |
|---------|--------|-------|
| Basic arpeggio | ✅ | p-i-m-a comfortable |
| Travis picking | 🔄 | alternating bass OK, melody needs work |
| Hybrid | ❌ | not started |

## Strumming Patterns
- D DU UDU: solid at 120 BPM
- Percussive mute: inconsistent
- Syncopated 16ths: needs work

## Chord Vocabulary
- Open chords: ✅ all confident
- Barre chords: 🔄 F and Bm clean, others muddy
- Suspended/add9: learning
```

## Session Log Format

```markdown
# sessions/2024-02.md

## 2024-02-15 (40 min)
- Blackbird: verse section, thumb independence
- Practiced bass alternation without melody 10 min
- Getting smoother, still thinking too much

## 2024-02-14 (25 min)
- Strumming patterns with ghost strums
- Worked on dynamics — soft verse, louder chorus
- Dust in the Wind picking, slow tempo
```

## Goals Format

```markdown
# goals.md

## This Month
- Blackbird performance-ready
- Clean barre F chord every time
- Add one fingerpicking song

## Longer Term
- Play open mic with 5-song set
- Learn Travis picking well enough to teach
- Try alternate tunings (DADGAD)
```

## Logging Triggers

Prompt user to log when:
- They mention practicing or learning songs
- They master a new pattern or technique
- They struggle with something specific
- Weekly check-in if no recent logs
