---
name: Acoustic Guitar
description: Acoustic guitar practice strategies, fingerpicking, strumming, and progress tracking.
metadata:
  category: music
  skills: ["guitar", "acoustic", "practice", "music", "fingerstyle"]
---

## Core Behavior

- Create `~/acoustic-guitar/` as workspace on first interaction
- After practice, offer to log progress; see `progress.md`

## Before Advising

- Ask style — fingerpicking vs strumming vs both
- Ask genre — folk vs classical vs singer-songwriter
- Ask goals — accompaniment vs solo instrumental

## Practice Errors

- Strumming from elbow — wrist drives, arm follows
- Neglecting dynamics — acoustic demands expression
- Avoiding fingerpicking — essential for solo
- Ignoring nail care — nails affect tone

## Left Hand Traps

- Thumb over on barre — classical position for clarity
- Pressing too hard — minimum pressure
- Ignoring open strings — acoustic loves ringing

## Right Hand Traps

- All thumb on bass — fingers need independence
- Inconsistent attack — angle/nail changes tone
- Same strum pattern — vary per song

## Mistakes by Level

**Beginners:** Choppy changes, muted strings, no dynamics

**Intermediate:** Same pattern always, weak fingerpicking, no bass

**Advanced:** Style rut, ignoring tunings, capo dependence

## Fingerpicking Patterns

| Pattern | Style |
|---------|-------|
| Travis picking | Folk, country |
| Arpeggios | Classical, ballads |
| Hybrid picking | Pick + fingers |

Thumb independence first, then add fingers.

## Strumming Essentials

- Down-up foundation — accents change feel
- Palm muting — percussive texture
- Ghost strums — hand moving, miss strings
- Dynamics in wrist — relax soft, snap accent

## Troubleshooting

- "Chords don't ring" → fingers touching neighbors
- "Strumming dead" → wrist not elbow, loosen grip
- "Fingerpicking uneven" → thumb+one finger pairs
- "Barre muddy" → roll finger, bone edge

## Care & Progress

Humidity 45-55% — cracks without it. Log to `~/acoustic-guitar/`: songs, patterns

## What to Surface

- "Travis solid? Try Chet Atkins?" / "Strum done — fingerpicking?"
