---
name: ace-music
description: Generate AI music using ACE-Step 1.5 via ACE Music's free API. Use when the user asks to create, generate, or compose music, songs, beats, instrumentals, or audio tracks. Supports lyrics, style prompts, covers, and repainting. Free API, no cost.
---

# ACE Music - AI Music Generation

Generate music via ACE Music's free hosted API (ACE-Step 1.5 model).

## Setup

**API Key** is stored in env `ACE_MUSIC_API_KEY`. If not set:
1. Open https://acemusic.ai/playground/api-key in the browser for the user
2. Ask them to sign up (free) and paste the API key
3. Store it: `export ACE_MUSIC_API_KEY=<key>` or add to TOOLS.md

## Quick Generation

Use `scripts/generate.sh` for one-shot generation:

```bash
# Simple prompt (AI decides everything)
scripts/generate.sh "upbeat pop song about summer" --duration 30 --output summer.mp3

# With lyrics
scripts/generate.sh "gentle acoustic ballad, female vocal" \
  --lyrics "[Verse 1]\nSunlight through the window\n\n[Chorus]\nWe are the dreamers" \
  --duration 60 --output ballad.mp3

# Instrumental only
scripts/generate.sh "lo-fi hip hop beats, chill, rainy day" --instrumental --duration 120 --output lofi.mp3

# Natural language (AI writes everything)
scripts/generate.sh "write me a jazz song about coffee" --sample-mode --output jazz.mp3

# Specific settings
scripts/generate.sh "rock anthem" --bpm 140 --key "E minor" --language en --seed 42 --output rock.mp3

# Multiple variations
scripts/generate.sh "electronic dance track" --batch 3 --output edm.mp3
```

Script outputs file path(s) to stdout. Send the file to the user.

## Advanced Usage (curl/direct API)

For covers, repainting, or audio input — see `references/api-docs.md` for full API spec.

Key task types:
- `text2music` (default) — generate from text/lyrics
- `cover` — cover an existing song (requires audio input)
- `repaint` — modify a section of existing audio

## Parameters Guide

| Want | Use |
|------|-----|
| Specific style | Describe in prompt: "jazz, saxophone solo, smoky bar" |
| Custom lyrics | `--lyrics "[Verse]...[Chorus]..."` |
| AI writes everything | `--sample-mode` |
| No vocals | `--instrumental` |
| Longer songs | `--duration 120` (seconds) |
| Specific tempo | `--bpm 120` |
| Specific key | `--key "C major"` |
| Multiple outputs | `--batch 3` |
| Reproducible | `--seed 42` |
| Non-English vocals | `--language ja` (zh, en, ja, ko, etc.) |

## Notes

- API is **free forever** (confirmed by ACE Music team)
- Base URL: `https://api.acemusic.ai`
- Audio returned as base64 MP3, decoded automatically by the script
- Duration: if omitted, AI decides based on content
- For best results, use tagged mode (prompt + lyrics separated)
