---
name: Accountant
description: Manage bookkeeping, financial statements, and tax planning with sound accounting practices.
metadata: {"clawdbot":{"emoji":"📊","os":["linux","darwin","win32"]}}
---

# Accounting Rules

## Important Boundaries
- This is financial information, not professional advice — recommend CPA for complex tax situations
- Tax laws vary by jurisdiction and change frequently — verify current rules
- Audited financials require licensed accountants — internal tracking differs from official statements
- Material decisions need professional review — DIY works for basics, not for high stakes

## Core Principles
- Double-entry: every transaction has equal debit and credit — books must balance
- Accrual vs cash basis: accrual records when earned/owed, cash when money moves — pick one consistently
- Matching principle: record expenses in same period as related revenue — timing matters
- Conservatism: recognize losses immediately, gains only when realized — err toward understating
- Materiality: small errors don't matter, significant ones do — focus effort proportionally

## Financial Statements
- Balance sheet: assets = liabilities + equity at a point in time — snapshot of position
- Income statement: revenue - expenses = profit over a period — performance summary
- Cash flow statement: where cash came from and went — profitability doesn't mean liquidity
- These three are interconnected — changes in one affect others
- Read all three together — each tells part of the story

## Bookkeeping Basics
- Record transactions as they happen — catching up creates errors
- Keep receipts and documentation — proof matters for taxes and audits
- Reconcile bank accounts monthly — catch errors and fraud early
- Separate business and personal finances — mixing creates legal and tax problems
- Chart of accounts organizes categories — set up properly at the start

## Cash Flow Management
- Profit isn't cash — you can be profitable and run out of money
- Accounts receivable is money owed to you — track aging, follow up on late payments
- Accounts payable is money you owe — manage timing strategically
- Cash flow forecast: project inflows and outflows weekly — avoid surprises
- Keep cash reserves — 3-6 months of expenses minimum for stability

## Tax Fundamentals
- Track deductible expenses throughout year — reconstructing at tax time misses items
- Estimated taxes quarterly for self-employed — underpayment triggers penalties
- Depreciation spreads asset costs over useful life — immediate deduction vs long-term
- Understand the difference between tax avoidance (legal) and evasion (illegal)
- Deadlines are real — extensions to file aren't extensions to pay

## Common Mistakes
- Mixing personal and business accounts — destroys liability protection and complicates taxes
- Not tracking small cash expenses — they add up to significant deductions
- Ignoring accounts receivable aging — old invoices rarely get paid
- Forgetting to reconcile — errors compound when not caught early
- Waiting until year-end for tax planning — many strategies require advance action

## Key Ratios
- Current ratio (current assets / current liabilities) — can you pay short-term debts?
- Gross margin (gross profit / revenue) — efficiency of core operations
- Net margin (net income / revenue) — bottom line profitability
- Debt to equity — financial leverage and risk
- Days sales outstanding — how fast you collect receivables

## Budgeting
- Start with revenue projections — be realistic, not optimistic
- Fixed vs variable costs — know which expenses scale with revenue
- Compare actual vs budget monthly — variance analysis reveals problems
- Zero-based budgeting: justify all expenses, not just increases — prevents bloat
- Budget for unexpected expenses — something will go wrong

## Working with Accountants
- Organize documents before meetings — billable hours add up fast
- Ask questions until you understand — it's your money and liability
- Provide complete information — surprises during audit are expensive
- Regular check-ins, not just at tax time — proactive planning beats reactive filing
- Understand what they're filing on your behalf — you sign, you're responsible
