# Word Choice Quick Reference

Common substitutions for clearer academic CS writing. Left column: avoid or reconsider. Right column: prefer.

## Overly Fancy → Simple and Clear

| Avoid | Prefer | Notes |
|---|---|---|
| utilize | use | Almost always |
| leverage | use, apply, build on | "Leverage" is business jargon |
| elucidate | explain, clarify | |
| facilitate | enable, help, allow | |
| endeavor | try, aim, attempt | |
| plethora | many, several, numerous | |
| myriad | many, various | |
| paradigm | approach, framework, model | Unless specifically referencing Kuhn |
| novel | new | Overused in CS papers; save for genuine novelty |
| state-of-the-art | best, strongest, leading | Fine in context but overused |
| aforementioned | this, the, (just refer to it) | Almost always deletable |
| henceforth | from here, going forward | |
| heretofore | previously, until now | |
| whilst | while | |
| amongst | among | |
| thereby | (restructure the sentence) | Often signals a sentence that is too long |

## Filler Phrases → Delete or Shorten

| Filler | Replacement |
|---|---|
| It is worth noting that | (delete — just state the thing) |
| It should be mentioned that | (delete) |
| It is important to note that | (delete, or start with "Notably,") |
| In order to | To |
| Due to the fact that | Because |
| In the event that | If |
| For the purpose of | To, For |
| A large number of | Many |
| In the case of | For, When |
| With regard to | About, Regarding |
| In light of the fact that | Because, Since |
| On the other hand | However, Alternatively |
| At this point in time | Now, Currently |
| In the majority of cases | Usually, Often |
| It has been shown that | (cite directly: "Smith et al. (2023) showed") |
| It is well known that | (either cite or just state the fact) |

## Hedging: Right Amount

**Too much hedging** (avoid):
- "It could potentially be argued that this might possibly suggest..."
- "We tentatively hypothesize that perhaps..."

**Appropriate hedging** (use when genuinely uncertain):
- "suggests" (for correlational evidence)
- "indicates" (for strong but not conclusive evidence)
- "may" (for speculation grounded in evidence)
- "we hypothesize" (for testable claims)

**No hedging needed** (for established facts or your own experimental results):
- "Our method achieves..." (not "Our method appears to achieve...")
- "The loss converges after..." (not "The loss seems to converge...")

## Transitions Between Ideas

| Relationship | Connectives |
|---|---|
| Addition | Moreover, Furthermore, Additionally, In addition |
| Contrast | However, In contrast, Nevertheless, On the other hand, Yet |
| Cause/Effect | Therefore, Consequently, As a result, Thus, Hence |
| Example | For example, For instance, Specifically, In particular |
| Clarification | That is, In other words, Specifically, More precisely |
| Comparison | Similarly, Likewise, In the same way |
| Concession | Although, While, Despite, Notwithstanding |
| Sequence | First, Second, Next, Then, Finally |
| Summary | In summary, Overall, To summarize |

Prefer variety — do not use "Moreover" at the start of every other paragraph.
