# Deep Research Quick Reference

## Invocation
- `/research` or mention "deep research" / "exhaustive analysis"

## Four Phases

| Phase | User Action | Your Action | Key Output |
|-------|-------------|-------------|------------|
| 1. Engagement | Answer clarifying questions | Reflect understanding, **WAIT** | Confirmed scope |
| 2. Planning | Review & approve plan | Present themes + execution plan, **WAIT** | Approved roadmap |
| 3. Execution | None (fully automated) | Execute ALL cycles with analysis | Raw research data |
| 4. Final Report | Review comprehensive report | Present academic narrative | Full paper |

## Stop Points (Only Three)
1. ✅ After clarifying questions (Phase 1)
2. ✅ After research plan presentation (Phase 2)
3. ✅ Final report delivery (Phase 4)

## Tool Usage Sequence (Per Theme)
1. **START:** `web_search` for landscape (count=20)
2. **ANALYZE:** Synthesize findings, identify patterns and gaps
3. **DIVE:** `web_fetch` for depth on key sources
4. **PROCESS:** Synthesize new findings, challenge assumptions
5. **REPEAT:** Second cycle targeting identified gaps

## Required Analysis After Every Tool Use
- Connect new findings to previous results
- Show evolution of understanding  
- Highlight pattern changes
- Address contradictions
- Build coherent narrative

## Research Standards
- Every conclusion cites **multiple sources**
- All **contradictions addressed**
- **Uncertainties acknowledged**
- **Limitations discussed**
- **Gaps identified**

## Writing Style (Final Report)
- **Flowing narrative** — paragraphs only, no lists
- **Academic but accessible**
- **Evidence integrated naturally** in prose
- **Progressive logical development**
- **Smooth transitions** between concepts

## Prohibited in Final Report
- Bullet points or numbered lists
- Tables (convert to prose)
- Isolated data without context
- Section headers without narrative

## Citation Standards (APA 7th)
- **Density:** 1-2 citations per paragraph
- **Format:** (Author, Year) in-text
- **References:** Full APA with hanging indent
- **All claims cited** — no exceptions

## Confidence Annotations
- **[HIGH]** — Multiple high-quality sources agree
- **[MEDIUM]** — Limited or mixed evidence
- **[LOW]** — Single source, needs verification
- **[SPECULATIVE]** — Emerging area

## Report Sections (Narrative Format)
1. **Executive Summary** — 2-3 paragraphs
2. **Knowledge Development** — evolution of understanding (6-8+ paragraphs)
3. **Comprehensive Analysis** — findings, patterns, contradictions, evidence (6-8+ paragraphs each subsection)
4. **Practical Implications** — applications, risks, future research (6-8+ paragraphs each subsection)
5. **References** — APA format, alphabetical
6. **Appendices** — optional

## Critical Reminders
- Stop only at three major points
- Always analyze between tool usage
- Show clear thinking progression
- Connect findings explicitly
- Build coherent narrative throughout
- No shortcuts or rushed analysis
