# Academic Deep Research 🔬

**Transparent, rigorous, self-contained research** — not a black-box API wrapper.

## Why This Skill Exists

Most "deep research" tools are wrappers around external APIs. You send a query, get a report, and have no idea what happened in between.

**This skill is different:**
- ✅ **Full methodology visible** — Every step documented, reproducible
- ✅ **No external dependencies** — Runs entirely on OpenClaw native tools
- ✅ **User control** — 3 explicit checkpoints for approval
- ✅ **Academic rigor** — APA citations, evidence hierarchy, confidence levels
- ✅ **Works offline** — No API keys, no cloud services

## Comparison with Cloud-Based Research Tools

| Feature | This Skill | Cloud API Wrappers |
|---------|------------|-------------------|
| Methodology | Fully documented | Black box |
| Dependencies | None | External API + key |
| Offline | ✅ Yes | ❌ No |
| User Checkpoints | 3 approval points | Usually none |
| Citation Format | APA 7th edition | Varies/unspecified |
| Evidence Hierarchy | Explicit (meta-analyses → opinion) | Unspecified |
| Output Control | Strict prose, no bullet points | Varies |
| Reproducibility | ✅ Same inputs = same process | ❓ Unknown |

## Core Features

### Mandated Research Cycles
Every theme gets **minimum 2 full research cycles**:
1. Broad landscape search → Analysis → Gap identification
2. Targeted deep dive → Challenge assumptions → Synthesis

No shortcuts. No single-pass summaries.

### Evidence Standards
- **Every conclusion cites multiple sources**
- **Contradictions must be addressed** — not hidden
- **Confidence annotations:** [HIGH], [MEDIUM], [LOW], [SPECULATIVE]
- **Evidence hierarchy:** Meta-analyses > RCTs > Observational > Expert opinion

### Academic Output
- Flowing narrative prose (no bullet point dumps)
- APA 7th edition citations (1-2 per paragraph)
- Proper paragraph structure: claim → evidence → analysis → transition
- Executive summary, methodology, findings, limitations, references

### User Control
Three mandatory stop points:
1. **Initial Engagement** — Clarify scope before research
2. **Research Planning** — Approve themes and approach
3. **Final Report** — Review completed analysis

## Quick Start

```
/research "Comprehensive analysis of [your topic]"
```

Or just ask for "deep research on..." or "exhaustive analysis of..."

## Research Protocol

### Phase 1: Clarification
Agent asks 2-3 essential questions, confirms understanding, **waits for you**.

### Phase 2: Planning
Agent presents:
- Major themes identified (3-5)
- Research execution plan (table format)
- Expected deliverables

**You approve before execution begins.**

### Phase 3: Execution (Auto)
For each theme, two full cycles:
- `web_search` (count=20) for landscape
- Analysis and gap identification
- `web_fetch` on primary sources
- Synthesis and assumption challenging
- Repeat for depth

**Required:** Explicit analysis between every tool call showing evolution of understanding.

### Phase 4: Report
Academic narrative with:
- Executive Summary
- Knowledge Development
- Comprehensive Analysis
- Practical Implications
- APA References

## File Structure

```
deep-research/
├── SKILL.md       # Full methodology (500+ lines)
├── README.md      # This file
├── quickref.md    # One-page cheat sheet
├── example.md     # Complete workflow example
└── LICENSE        # Apache 2.0
```

## When to Use This

- Literature reviews requiring academic rigor
- Competitive intelligence with source verification
- Complex topics needing multi-source synthesis
- Any research where you need to **show your work**
- When you don't trust black-box AI summaries

## License

Apache 2.0 — See [LICENSE](LICENSE)

---

**Built for researchers who care about methodology, not just outputs.**
