/**
 * Agent Backlink Network - Type Definitions
 * 
 * Custom Nostr Event Kinds:
 * - 30100: Site Registration (parameterized replaceable)
 * - 30101: Exchange Complete (public record)
 * - 30102: Agent Reputation
 * - 4: Exchange Proposal/Accept (NIP-04 encrypted DM)
 */

export const EVENT_KINDS = {
  SITE_REGISTRATION: 30100,
  EXCHANGE_COMPLETE: 30101,
  AGENT_REPUTATION: 30102,
  ENCRYPTED_DM: 4,
} as const;

export interface SiteRegistration {
  url: string;
  businessName: string;
  businessType: string;
  location: {
    city: string;
    state: string;
    country: string;
    radiusMiles: number;
  };
  linkPages: string[];
  lookingFor: string[];
  domainAuthority?: number;
  contact?: string; // Optional contact info
}

export interface ExchangeProposal {
  type: 'proposal';
  proposalId: string;
  fromSite: string; // URL
  toSite: string; // URL
  linkPage: string; // Where proposer will place link
  anchorText?: string;
  message?: string;
}

export interface ExchangeAccept {
  type: 'accept';
  proposalId: string;
  linkPage: string; // Where acceptor will place link
  anchorText?: string;
  message?: string;
}

export interface ExchangeReject {
  type: 'reject';
  proposalId: string;
  reason?: string;
}

export interface ExchangeComplete {
  proposalId: string;
  siteA: {
    url: string;
    linkPage: string;
    linkUrl: string; // Full URL of the page with link
  };
  siteB: {
    url: string;
    linkPage: string;
    linkUrl: string;
  };
  completedAt: number; // Unix timestamp
  verified: boolean;
}

export interface AgentReputation {
  agentPubkey: string;
  completedExchanges: number;
  activeExchanges: number;
  disputedExchanges: number;
  avgResponseTime: number; // hours
  score: number; // 0-100
}

export interface LocalState {
  privateKey: string;
  publicKey: string;
  npub: string;
  sites: SiteRegistration[];
  pendingProposals: {
    id: string;
    direction: 'incoming' | 'outgoing';
    proposal: ExchangeProposal;
    fromPubkey: string;
    toPubkey: string;
    status: 'pending' | 'accepted' | 'rejected' | 'completed';
    createdAt: number;
  }[];
  completedExchanges: string[]; // Proposal IDs
  relays: string[];
}

export interface VerificationResult {
  url: string;
  targetUrl: string;
  found: boolean;
  anchorText?: string;
  linkType?: 'dofollow' | 'nofollow' | 'sponsored' | 'ugc';
  checkedAt: number;
  error?: string;
}
