#!/usr/bin/env node
// Seed the ABN network with test sites
// Usage: node src/seed.js

import { registerSite } from './register.js';

// Test sites to seed the network
const testSites = [
  {
    name: 'San Diego Plumbing Pros',
    url: 'https://sdplumbingpros.example.com',
    city: 'San Diego',
    state: 'CA',
    industry: 'plumbing',
    type: 'local-business',
    da: 28,
    wantLinks: ['homepage', 'service-pages'],
    canOffer: ['footer', 'partners-page', 'blog']
  },
  {
    name: 'Phoenix HVAC Solutions',
    url: 'https://phoenixhvac.example.com',
    city: 'Phoenix',
    state: 'AZ',
    industry: 'hvac',
    type: 'local-business',
    da: 32,
    wantLinks: ['homepage', 'ac-repair'],
    canOffer: ['partners-page', 'resources']
  },
  {
    name: 'LA Electrical Experts',
    url: 'https://laelectrical.example.com',
    city: 'Los Angeles',
    state: 'CA',
    industry: 'electrical',
    type: 'local-business',
    da: 35,
    wantLinks: ['homepage', 'service-pages'],
    canOffer: ['footer', 'blog', 'partners-page']
  },
  {
    name: 'Austin Roofing Masters',
    url: 'https://austinroofing.example.com',
    city: 'Austin',
    state: 'TX',
    industry: 'roofing',
    type: 'local-business',
    da: 25,
    wantLinks: ['homepage'],
    canOffer: ['partners-page', 'resources']
  },
  {
    name: 'Denver Construction Co',
    url: 'https://denverconstruction.example.com',
    city: 'Denver',
    state: 'CO',
    industry: 'construction',
    type: 'local-business',
    da: 40,
    wantLinks: ['homepage', 'services'],
    canOffer: ['blog', 'partners-page', 'resource-page']
  }
];

async function seedNetwork() {
  console.log('🌱 Seeding ABN network with test sites...\n');
  
  for (const site of testSites) {
    try {
      await registerSite(site);
      console.log(`\n✓ Registered: ${site.name}\n`);
      console.log('─'.repeat(50) + '\n');
      // Small delay between registrations
      await new Promise(r => setTimeout(r, 1000));
    } catch (err) {
      console.error(`✗ Failed to register ${site.name}:`, err.message);
    }
  }
  
  console.log('\n🎉 Seeding complete! Run "npm run query" to see the sites.');
}

seedNetwork();
